=======================================
          UPN-Calc  2.0
=======================================
               von
         Wolfgang Fhrer
           Idastr. 19
      45663 Recklinghausen
      Telefon 02361/891344
   CompuServe ID 100415,3227
 MAUSNet -> Wolfgang Fhrer@DO

UPN-Calc 2.0 stellt ihnen einen tech- 
nisch-wissenschaftlichen taschenrechner 
mit UPN-logik zu verfgung.
UPN heit Umgekehrte Polnische Notation 
und ist eine rechenlogik, die nach dem 
prinzip der "Polnischen Notation" 
arbeitet, die von dem polnischen 
mathematiker Jan Lukasiweicz (1878- 
1956) entwickelt wurde. Sie ist 
wesentlich leistungsfhiger, als da, 
was wir von normalen taschenrechnern 
mit AOS (Algebraic Operating System) 
kennen.
Neben der unbertroffen qualitt und 
flexibilitt der HP-Taschenrechner ist 
es wohl vor allem der verwendung der 
UPN-logik zuzuschreiben, da diese 
rechner fr wissenschaftler, studenten 
und mathematiker ein unentbehrliches 
werkzeug darstellen. Es lohnt sich 
wirklich sich mit UPN vertraut zu 
machen.
Ich habe 1983 mit einem HP-41CV 
angefangen, und bin seitdem der UPN- 
logik verfallen. Das war auch ein grund 
dafr, da ich bisher in FORTH 
programmiert habe.

Die vorzge der UPN:

* Zu jedem Zeitpunkt wird nur eine 
Funktion ausgefhrt.

* Wird eine funktionstaste gedrckt, 
wird die entsprechende funktion sofort 
ausgefhrt. Auf diese weise arbeitet 
man sich schritt fr schritt durch die 
rechnung.

* Zwischenergebnisse werden sofort 
angezeigt - es gibt keine "versteckten" 
resultate. Die rechnung kann so, 
schritt fr schritt, berprft werden.

* Zwischenergebnisse werden vom rechner 
aufbewahrt, es brauchen keine werte 
notiert werden.

* Man kann nach genau der gleichen 
methode an die lsung des problems 
herangehen, wie man es bisher vom 
rechnen mit papier und bleistift her 
gewohnt war. Es ist daher in der regel 
unntig, sich bereits im voraus 
gedanken ber das ntige vorgehen zu 
machen.

* Man mu sich keine gedanken ber 
notwendige klammern in der rechnug 
machen, denn UPN macht klammern 
berflssig. 

* Der STACK (rechenstapel - wird spter 
erklrt) gibt einem das gefhl, stndig 
einen notizzettel zur hand zu haben, 
auf dem man zahlen lassen kann, ohne 
da man sie erneut eintippen mu.


Ich gebe zu, da das umlernen etwas 
zeit braucht (eine bis mehrere 
stunden), aber schlielich man hat ja 
auch gerne die zeit in der fahrschule 
geopfert, weil man wei, da hinterher 
vieles schneller und bequemer ist.

Auerdem sind in diesem programm 
stndig die 5 obersten "stackelemente" 
bzw. zahlen sichtbar und so die UPN- 
logik leicht nachzuvollziehen und zu 
lernen.



--------------------------------------
           SHAREWARE
--------------------------------------

Beachten sie bitte, da UPN-Calc 2.0 
Shareware ist. Wenn sie dieses programm 
regelmig benutzen, bitte ich sie, 
sich registrieren zu lassen. Ich nehme 
eine gebhr von DM 10.-
Wer sich ber CompuServe registrieren 
lassen will mu 10 dollar berappen (ich 
kann es leider nicht ndern - das ist 
der mindestbertag, der verlangt wird). 
Dies knnen sie ber CompuServe -> GO 
SWREG machen (Registration ID 3844), 
oder sie schicken mir einen Brief mit 
Diskette, der einen an sich selbst 
addressierten und frankierten 
rckumschlag enthlt. Sie erhalten dann 
eine persnliche version - mit namens-
nennung in der titelbox.
Als registrierter user knnen sie mich 
durch e-mail in CompuServe unter ID 
100415,3227 erreichen, oder im MAUSNet 
unter "Wolfgang Fhrer@DO", oder 
telefonisch unter 02361/89134 (bitte 
nur wenn es dringend ist). Bitte teilen 
sie mir auch mit, wenn sie einen fehler 
entdecken. Ich werde ihn beheben und 
ihnen die korrigierte version per 
CompuServe oder MAUSNet zuschicken.
Dieses programm wird weiterentwickelt 
und erweitert. Ein UPGRADE wird 
jederzeit mglich sein.

Dieses programm ist, nach bestem wissen 
und gewissen, fehlerfrei in der 
ausfhrung der mathematischen 
funktionen. Ich habe viel zeit damit 
verbracht, die rechnungen, 
zwischenergebnisse und ergebnisse mit 
einem HP-28S (UPN-taschenrechner) 
gegenzuchecken. Trotzdem kann man 
rechenfehler nie ganz ausschlieen.

Deswegen weise ich darauf hin, das ich 
fr schden, die durch die benutzung 
dieses programmes entstehen, keine 
haftung bernehme.


--------------------------------------
          DAS PROGRAMM
--------------------------------------

UPN-Calc ist vollstndig auf dem ATARI- 
Portfolio entwickelt worden, und ist in 
PowerBASIC geschrieben.

Vor der ausfhrung des programms mu 
PBRUN.COM, die runtime-libary, 
gestartet werden. Diese libary bleibt
bis zu einem reset im speicher
erhalten. PBRUN.COM ist mit DIET.EXE
lauffhig gepackt.

Die interne RAM-Disk ist so einzu-
stellen, das ca. 70 kbyte freier RAM 
zur verfgung stehen (siehe CHKDSK).
UPN201.COM ist mit DIET.EXE auf ca. 43%
der ursprnglichen lnge lauffhig 
gepackt.

UPN-Calc erkennt ab version 2.0 ob die 
englische oder die deutsche 
tastaturbelegung eingeschaltet ist, und 
korriegiert selbststndig die eingabe.



--------------------------------------
          ALLGEMEINES
--------------------------------------

In diesem Manual werden zu drckende 
tasten, bzw. funktionstasten in eckige 
klammern gesetzt. tabei ist auch auf 
gro- und kleinschreibung zu achten, da 
zu vielenpfunktionen auch umkehr- 
funktionen existieren, die ber die 
gleiche taste mit SHIvT zu erreichen 
sind.
      [q] sin  - sinus
      [Q] asin - arcussinus

Eine komplette eingabesequenz wird in 
anfhrungsstriche gesetzt und die 
eckigen klammern werden weggelassen,
auerdem wird [cr] durch ] abgekrzt.

  "123]4+"
   heit: [1][2][3][cr][4][+]

Da bei manchen funktionen mehr als ein
wert als ergebnis erscheint, wird 
hinter dem ergebnis die Stackposition 
und evtl. ein kommentar angegeben.

  [g] R-P rechtwinklig in polar

  "4]3g"
  Ergebnis:    5 |2| radius
           53.13 |1| winkel alpha

  [G] P-R polar in rechtwinklig

  "5]53.13G"
  Ergebnis:    3 |2| x
               4 |1| y

Die durchgehend kleine schrift ist
einfach nur 'ne macke von mirn Ich 
meine, da die englnder das schon 
richtig machen; vielleicht ist es aber 
auch ein bichen faulheit.



--------------------------------------
            ANZEIGE
--------------------------------------

Die anzeige von UPN-Calc ist in vier 
bereiche aufgeteilt. Der TOS ist 
gleichzeitig das eingabefeld, in dem 
auch der cursor blinkt.
In der linken anzeigenhlfte oberhalb 
des trenungsstriches werden die 5 
obersten STACK-Elemente angezeigt.
Der TOS wird mit der durch FIX 
festgelegten stellenanzahl angezeigt, 
die brigen stackelemente mit 6 
stellen.
In der rechten anzeigenhlfte oberhalb 
des trenungsstriches werden 5 speicher- 
register angezeigt.

In der linken oberen ecke werden von 
oben nach unten folgendes angezeigt:

Indikator fr den winkelmodus, in dem 
die trigonometrischen funktionen 
arbeiten.

In der mitte sieht man die zuletzt 
gedrckte funktionstaste. Eine hilfe, 
wenn man sich mal verdrckt hat und die 
funktion rckgngig machen will.

Als drittes ist der wert des stack- 
pointers zu sehen, der angibt wieviele 
werte auf dem STACK liegen. Mehr als 99 
werte sind nicht erlaubt.

Unterhalb des trennungsstriches wird 
die sich ndernden tastenbelegung 
angezeigt.


 DEGREE               5            0
LAST:                 4            0
TOS:  0      STACK    3  REGISTER  0
    bis 99    2   1-5(45)  0
                       1            0

Q SIN  COS  TAN  LOG  LN   X^2 Z
A!/iplST/RCHR/MS c%s  R-P 1/y^xH

^                                     ^
 Tastaturhilfe 

Die belegungen der tasten, die sich 
nicht ndern, lassen sich mit der 
atari-taste zur hilfe einblenden.

Die tabulatortaste zeigt das copyright 
und die registrationsnummer mit user- 
namen.



--------------------------------------
          ZAHLENEINGABE
--------------------------------------

UPN-Calc ist von der tastenbelegung her 
so programmiert, da der nummernblock 
simuliert wird. Es ist also nicht 
wichtig, ob er eingeschaltet ist oder 
nicht.

Im programm selbst luft eine schleife, 
die stndig die tastatur abfragt. Das 
programm unterscheidet bei einem 
tastendruck zwischen zifferntasten und 
funktionstasten.
Die tasten "0123456789." werden als 
zifferntasten interpretiert. Solange 
eine solche taste gedrckt wird, bleibt 
das programm im zahleneingabemodus. 
Sobald eine andere taste gedrckt wird, 
wird die eingegebene zahl auf den STACK 
(den rechenstapel) geschoben und die 
funktion ausgefhrt. Um zwei zahlen 
nacheinander einzugeben, mu die erste 
zahl mit [cr] auf den stack gebracht 
werden, danach wird die zweite zahl 
eingegeben.
Wird nach der eingabe einer zahl eine 
funktionstaste gedrckt, fhrt die 
funktion das [cr], wenn ntig, selbst 
aus. Dadurch kann einiges an [cr]- 
tastendrcken eingespart werden.

Der STACK (rechenstapel) stellt die 
zentrale rechenumgebung dar. Jede zahl, 
mit der gearbeitet werden soll, mu 
erst auf den STACK.
Der STACK arbeitet mit der sogenannten 
LIFO-Struktur (Last In - First Out). 
Jede neue zahl wird oben auf den Stapel 
gelegt (auch wenn es in der anzeige 
genau umgekehrt aussieht). Die 
funktionen die aufgerufen werden, 
bearbeiten dann das oberste stack- 
element (zuletzt eingegebene zahl), 
bzw. die obersten zwei oder mehr.

Negative zahlen mssen in zwei 
schritten eingegeben werden, weil "-" 
sofort als funktion gewertet und 
ausgefhrt wird. Man gibt also erst den 
zahlenwert ein und drckt dann die 
funktion

  [] chs - change sign

Eingabe : "123]" od.
          "123"
Ergebnis: -123 |1|

Auch zahlen mit zehnerexponent mssen 
in zwei schritten eingegebe werden.

  [] eex-exponent anhngen

Eingabe : "1.23]13]" od.
          "1.23]13"
Ergebnis: 1.23E+013 |1|

Eingabe : "1.23]13]" od.
          "1.2313"
Ergebnis: -1.23E-013 |1|



--------------------------------------
          STACKBEFEHLE
--------------------------------------

Die UPN-logik bentigt befehle, die es 
erlauben, zahlen auf dem STACK in der  
reihenfolge zu ndern. Zwischen- 
ergebnisse, die auf dem STACK liegen, 
knnen so fr nachfolgende rechnungen 
in die richtige position gebracht 
werden.


[x] swap - die obersten zwei  
          stackelemente vertauschen

  123 |2| <Ŀ        456 |2|
  456 |1| <  [x]   123 |1|
 =========          =========


[c] rot - das 3. stackelement nach 1

  123 |3| Ŀ        456 |3|
  456 |2| ^         789 |2|
  789 |1| ^<  [c]   123 |1|
 =========          =========


[v] over - das 2. element
           nach 1 duplizieren

                    123 |3|
  123 |2| Ŀ        456 |2|
  456 |1|   [v]    123 |1|
 =========<       =========


[b] pick - das n-te element auf TOS
Mit diesem befehl kann man ein 
beliebiges element auf den TOS 
duplizieren. "5b" dupliziert das 
element, da auf position 5 angezeigt 
wird, auf den TOS. "1b" entspricht "]" 
(dup) "2b" entspricht "v" (over)


[einf/entf] drop - 1. element lschen

  123 |2|
  456 |1|   ^  [e/e]  123 |1|
 =========         =========


[y] undrop - macht drop rckgngig
Um den wirkungsbereich dieser funktion 
richtig zu verstehen, sei hier kurz der 
interne stackaufbau beschrieben.
Der STACK hat eine gre von 100. Das 
heit, das 100 zahlen auf dem STACK 
gehalten werden knnen, wobei aber nur 
die obersten 5 werte angezeigt werden.
Den obersten wert auf dem STACK nennt 
man auch TOS (Top Of Stack). An welcher 
stelle dieser wert liegt, wird durch 
den stackpointer festgehalten. In der 
stackanzeige erscheinen immer der TOS 
an position 1 sowie die 5 darunter 
liegenden werte. Nach der eingabe von 
"1]2]3]4]" sieht der STACK so aus:


speicher 0:   ende     |5|         .
         1:      1     |4| anzeige .
         2:      2     |3|         .
         3:      3     |2|         .
 TOS ->  4:      4     |1|         .
        ===stackpointer===         .
         5:                        .
         .                         .
         .                         .
         .                         .
       100:                        .


Gibt man weiter "5]6]7]8]9]" ein:


speicher 0:   ende                 .
         1:      1                 .
         2:      2                 .
         3:      3                 .
         4:      4                 .
         5:      5     |5|         .
         6:      6     |4| anzeige .
         7:      7     |3|         .
         8:      8     |2|         .
 TOS ->  9:      9     |1|         .
        ===stackpointer===         .
        10:                        .
         .                         .
         .                         .
         .                         .
       100:                        .

Der befehl [y] undrop setzt den 
stackpointer bei jeder ausfhrung eine 
position vor, in richtung speicher 100.
Das ist dann die grenze fr diesen 
befehl. Wenn eine speicherstelle noch 
nicht benutzt worden ist, erscheint 
eine 0 in der stackanzeige, weil das 
der anfangszustand des speichers ist.

[e/e] (drop) lscht analog dazu nicht 
wirklich die zahl sondern setzt den 
stackpointer eine position zurck in 
richtung speicher 0. Die zahl bleibt 
aber weiterhin in dieser speicherstelle 
bestehen, bis sie durch eine andere 
berschrieben wird. Deswegen kann die 
zahl auch durch [y] zurckgeholt 
werden.



--------------------------------------
        RECHENBEISPIELE
--------------------------------------

Es folgen jetzt einige rechenbeispiele, 
die sie mit der UPN-logik vertraut 
machen sollen, und ihnen die vorzge 
dieser logik zeigen. Die tasten- 
belegungen knnen sie dem anhang 
entnehmen.

AOS :  3+5=
UPN :  3]5+

AOS :  27/9=
UPN :  27]9/

AOS :  (17-5)*4=
UPN :  17]5-4*

AOS :  (17-5)/(12-8)=
UPN :  17]5-12]8-/

Wie sie an diesem beispiel sehen, 
werden die klammern zuerst fr sich 
gelst so wie man es auch auf dem 
papier machen wrde. Anschlieend wird 
mit den zwischenergebnissen 
weitergerechnet. Wie man an der 
gegenberstellung sieht, spart man 3 
tastendrcke und die klammerergebnisse 
bekommt man zur berprfung gratis 
dazu.

       _____                       .
      /     |                      .
    \/ 16*5   +2                   .
   -  =  X            .
      (4+2)^2                      .

AOS : ((16*5)+2)/(4+2)^2=
UPN : 16]5*Z2+4]2+z/


   3^2-                           .
    - (3-7)                   .
     4                             .
   = X              .
           3^2-                   .
     4^2 +                    .
             4                     .

Da grbelt man schon mal, nicht war?
Hier die auflsung!

AOS :((3^2-)/4-(3-7))/(4^2+(3^2-)/4)=

In diesem Beispiel sieht man zwar, das 
da zwei identische terme vorkommen, 
aber ohne speicher (vorher ausrechnen 
und abspeichern, dann abrufen) nutzt 
einem die erkenntnis nichts. Und was 
mu man da aufpassen wenn man das an 
einem stck eingeben mu!
Anders in UPN. Einfach anfangen - da 
kommt man schon durch.

              mit "enter"
             term duplizieren
            
UPN : 3z-4/]3]7--4zc+/
                    
                     term holen
                      mit "rot"

Alles in allem hat man 18 tastendrcke 
gespart und hat sich auch keine 
gedanken darum machen brauchen, wo 
unbedingt klammern hingeren - auf- 
bzw. zugemacht werden mssen.
Wenn das jetzt keine werbung fr UPN 
ist, dann wei ich aber auch nicht 
mehr!



--------------------------------------
             HILFE
--------------------------------------

Ich habe dem benutzer, noch eine kleine 
online-hilfe spendiert. Durch drcken 
der Atari-Taste [/|\] erscheinen die 
sich nicht verndernden tasten- 
belegungen oben in der Anzeige. Dabei 
steht ganz links bzw. ganz rechts die 
erste bzw. letzte taste dieser reihe. 
Dazwischen sind durch "" getrennt die 
funktionen zu sehen. Man hat dann alle 
tastenbelegungen auf einem blick.
Die erste obere hilfereihe die 
angezeigt wird, bezieht sich nur auf 
die geSHIFTeten tasten 1-6, weshalb 
auch "!" und "&" als linke/rechte taste 
angegeben sind.
Mit "?" bis "del/ins" ist die diagonale 
rechts neben dem nummernblock gemeint.

Die unteren zwei reihen bleiben immer 
sichtbar. Ist ein hilfetext nur in 
grobuchstaben geschrieben, liegt unter 
der Tasten (mit SHIFT) die umkehr-funktion.
Folgende hilfen sind etwas getrickst:

[f] %ch   - % changing
            prozentuale nderung
[F] %split - % splitting
            prozentuale aufteilung

Die hilfe hierfr lautet "C%S"

[h] 1/x  - kehrwehrt
[H] y^x  - potenzfunktion

Die hilfe hierfr lautet "1/y^x"

Wer sehr hufig mit dem programm 
arbeitet, so wie ich, wei es zu 
schtzen, wenn unter den unvernder- 
lichen tasten (die mit der ATARI-taste 
erscheinen) kleine aufkleber angebracht 
sind.



--------------------------------------
           FUNKTIONEN
--------------------------------------

Die funktionen q-z bzw. Q-Z bedrfen 
wohl keinerlei erklrung. Die winkel- 
funktionen reagieren selbstverstndlich 
auf den eingestellten winkelmodus.

[$] degree/radian
    Diese taste schaltet zwischen den
    beiden Winkelarten um

[#] fix
    Mit dieser taste wird die anzeigen-
    breite, nicht die anzahl der nach-
    kommastellen, eingestellt. Der
    gewnschte wert mu zuvor auf den
    STACK gebracht werden. Es sind bis
    zu 15 stellen erlaubt, da alle
    mathematischen funktionen mit 16
    signifikanten stellen rechnen.
    "3h15%" = 0.333333333333333 |1|

[!] Schaltet die erste Tastenbelegung
    an (normal)

["] Schaltet die zweite Tastenbelegung
    an (statistik)
    Unter den STACK/Register-nummern
    erscheint "<  0>" fr einfache
    statistik (nur x) oder "  0" fr
    regressionsanalyse (x und y)
    Der angezeigt wert ist die anzahl
    der Daten(paare) (register 21)



--------------------------------------
    Die funktionen bei NORMAL
--------------------------------------

[a] fact
    Ermittelt die fakultt des TOS.
    "6!" = 720 |1|
    gesetzt.

[A] Interpolieren. In einer tabelle
    ber dampfdruck und dazugehrender
    temperatur finden wir folgende
    werte: 200'C == 15.551 bar
           220'C == 23.201 bar
    Welcher druck entsteht bei 210'C ?
    "200]15.551]220]23.201]210A"
                  = 19.376 |1|

    Welche temperatur bentige ich
    fr 20.0 bar?
    (jetzt nachmachen !  \=drop)
    "\\\xyyx20A"  = 211.63 |1|
    Ich sach ja:
    "Es geht nicht's ber UPN !"

    Da das interpolieren nichts anderes
    macht, als die steigung zwischen
    zwei punkten zu berechnen, kann man
    sie auch dazu benutzen, werte
    auerhalb des bereiches zu
    ermitteln.

    Beispiel: Es wird ein groer tank
    leergepumpt. Um 11:48 Uhr hat er
    einen stand von 161 tonnen.
    Um 15:18 Uhr hat er einen stand
    von 56 tonnen. Die verpumpung
    verluft sehr gleichmig.

    Welchen stand haben wir um 17 Uhr?
    "11.48d161]15.18d56]17dA"= 5.0 |1|

    Wann wird der Tank leer sein?
    (werte drehen wie oben !)
    "\\\xyyx0AD" = 17.10 |1|
    Der Tank wird also 17:10 leer.
    Na ja, feierabend gerettet.

[s] sto
    speichert den TOS in dem
    angegebenen register
    "2.3]2s" speichert den TOS (2.3) in
    register 2

[S] rcl
    recall holt einen wert aus dem
    register und kopiert ihn auf den
    STACK. "2S" holt die 2.3 wieder
    auf den TOS.

[d] hr
    hour wandelt den TOS um.
    HR wandelt eine zahl im format
    hh.mmss in ein dezimales format
    um, in dem zeiten durch +, -,
    *, /, ect. bearbeitet werden
    knnen.

[D] hms
    wandelt den TOS wieder in hh.mmss
    zurck.

    Findet man auf einer CD die titel-
    lngen  1:09:05 , 12:30 , 5:45
    kann man sie wie folgt addieren:
   "1.0905d.1230d.0545d++D"= 1.2720 |1|
    1 stunde 27 minuten 20 sekunden

[f] %ch  (% changing)
    ermittelt die prozentuale nderung
    eines wertes. vorher 50, hinterher
    57 sind +14%
    "50]57f" =  14 |1|

[F] %sp  (% splitting)
    eine funktion die ich selbst hufig
    bentige. Ein beispiel zeigt am
    besten die funktion:

    Es soll eine mischung aus zwei
    komponenten gemacht werden.
    Komponente 1 = 24%
    Komponente 2 = 76%
    Gesamtmenge = 250 l

    "24]76]250F" =  60 |2| l komp. 1
                   190 |1| l komp. 2
    oder:
     85 l komponente 1 und
    150 l komponente 2 waren
    eine gute mischung. Fr 250 l
    gesamt lautet die mischung:

    "85]150]250F" =  90.4 |2| komp. 1
                    159.6 |1| komp. 2
    oder:
    Der gesamtpreis der ware ist
    124.30 DM. Wie hoch ist die darin
    enthaltene MwSt von 15%?

    "100]15]124.30F" =  108.09 |2|
                         16.21 |1|

    Die ware kostet 108.09 DM plus
    16.21 DM MwSt (15%)

[g] R-P
    Rechtwinklige koordinaten in
    polarkoordinaten umwandeln.

[G] P-R
    Polarkoordinaten in rechtwinklige
    koordinaten umwandeln

    "4]3g"
    Ergebnis:    5 |2| r
             53.13 |1| winkel alpha

    "5]53.13G"
    Ergebnis:    3 |2| x
                 4 |1| y

     y              y
    4|.....+        |     +          .
     |     :        |    /r=5        .
     |     :        |   /            .
     |     :        |  /             .
     |     :        | /\53.13       .
     |     :        |/  )            .
    --------- x    ----------- x     .
     |     3        |                .
                                     .
    rechtwinklig      polar          .

[h] 1/x
    Reziprokwert vom TOS

[H] y^x
    Potenzfunktion
    2^3 -> "2]3H" = 8 |1|

    Die 4-te wurzel aus 256 zieht man
    wie folgt.
    "256]4hH" = 4 |1|



--------------------------------------
    Die funktionen bei STATISTIK
--------------------------------------

[q] n
    Zeigt die normalen register 1-5 an

[r] R
    Zeigt die Regressionswerte und das
    gewhlte modell an

    * - Summe x*y
    y - die regressionsformel (=a+b*x)
    a - den wert von a
    b - den wert von b
    r - den korrelationskoeffizienten
        (ma fr die genauigkeit der
         anpassung)

    Die werte knnen mit recall und
    der davorstehenden nummer auf den
    TOS geholt werden
    "3S" holt den wert von a auf TOS

[R] ?
    Hier kann das regressionsmodell
    gendert werden. Das brauch aber
    erst nach der dateneingabe gemacht
    werden.

[t] X
    Zeigt die X-Statistikwerte an

    x - summe der x
    2 - summe der x^2
     - arithmetisches mittel der x
     - standartabweichung
        der grundgesamtheit (n)
    S - standartabweichung
        der stichprobe (n-1)

    Die werte knnen mit recall und
    der davorstehenden nummer auf den
    TOS geholt werden

[T] Y
    Zeigt die Y-Statistikwerte an

    y - summe der y
    2 - summe der y^2
     - arithmetisches mittel der y
     - standartabweichung
        der grundgesamtheit (n)
    S - standartabweichung
        der stichprobe (n-1)

    Die werte knnen mit recall und
    der davorstehenden nummer auf den
    TOS geholt werden

[z] +
    summiert wert(epaar)
    "2]3.1z" (x=2, y=3.1)

[Z] *
    summiert wert(epaar) n-mal
    "2]3.1]4Z" (x=2, y=3.1, 4-mal)

[a] ready
    nach der dateneingabe immer diese
    funktion bettigen, um die
    standartabweichungen und
    regressionsparameter neu zu
    berechnen. Erfolgt nicht auto-
    matisch

[s] store
    ein abspeichern in die statistik-
    register ist mglich. Dadurch
    knnen regressionskurven getestet
    werden.

[S] recall

[d] SD  (single data)
    So werden von z/Z/h/H nur x werte
    erwartet und bearbeitet

[D] RG  (regression)
    So werden von z/Z/h/H x,y paare
    erwartet und bearbeitet

[f] BST  (best)
    Nach erfolgter dateneingabe im
    RG-modus wird die kurve mit dem
    hchsten korrelationskoeffizienten
    ermittelt. (Die praxis zeigt, das
    das nicht unbedingt die beste
    anpassung sein mu. Also selbst
    verschiedene kurven testen!)

[F] 
    Die graphische anzeige aller punkte
    und gewhlter kurve.
    Die koordinaten werden dabei dem
    STACK entnommen!
    Der anzeigenbereich mu nur einmal
    festgelegt werden.

[g] X'
    Zu einem gegebenen y-wert wird, je
    nach gewhltem modell, durch die
    angezeigte regressionsformel
    der x-wert berechnet.

    Auf dem STACK erhlt man:
            |2| x-wert
            |1| y-wert

    ACHTUNG, x- und y-wert werden
    gedreht! Man sieht also bei der
    ausfhrung von X' und Y' immer
    den x-wert oben und den y-wert
    unten. Ich finde das praktischer.

[G] Y'
    Zu einem gegebenen x-wert wird, je
    nach gewhltem modell, durch die
    angezeigte regressionsformel
    der y-wert berechnet.

    Auf dem STACK erhlt man:
            |2| x-wert
            |1| y-wert

[h] -
    entfernt wert(epaar)

[H] -*
    entfernt wert(epaar) n-mal


Die anzahl der daten(paare) werden in 
dem trennungsstrich unter der 
STACK/RGISTER trennung angezeigt. Es 
ist real das register 21.


Beispiel:
An einem wasserrohr wird die abhngig- 
keit der menge vom leitungsdruck 
untersucht. Man kommt zu folgender 
tabelle:

x 1.002.003.004.005.006.00  bar

y 3.595.076.176.907.517.71  l/min

Zunchst whlt man regressionsanalyse 
und lscht alte daten mit "Dy". Dann 
gibt man ein:
"1.00]3.59z2.00]5.07z"... usw.
Werte die falsch eingegeben wurden, mu 
man sofort lschen indem man "h" 
bettigt und dann DROP DROP ausfhrt, 
damit das falsche wertepaar mit "F" 
nicht zur anzeige gebracht wird.
Dann eingabe mit "a" abschlieen und 
mit "f" beste kurve suchen lassen.
Anschlieend mit "F" anzeigen lassen.
Fr x-min whlt man z.b. 0
 "  x-max   "    "   "   10
 "  y-min   "    "   "   0
 "  y-max   "    "   "   10
Zunchst erscheinen alle wertepaare auf 
der Anzeige.
Dabei werden ALLE zahlen auf dem STACK 
als datenpaare angesehen und zur 
anzeige gebracht!
Nach irgendeinem tastendruck erscheint 
dann auch die regressionskurve. Man kan 
das zeichnen der kurve durch einen 
tastendruck abbrechen. In unserem 
beispiel ist die anpassung rechnerisch 
zwar gut ("r" ist nahe 1), aber optisch 
lt sie einiges zu wnschen brig. 
Durch tastendruck verlassen wir die 
anzeige und whlen ein anders modell 
(durch erfahrung findet man schnell was 
man sucht).
Wir drcken "R" um ein anders modell zu 
whlen und entscheiden uns fr "sg" 
(reziprok-hyperbolisch). Der 
korrelationskoeffizient in der 
registeranzeige ist nur unwesentlich 
schlechter.
Mit "]" bernehmen wir die wahl und 
"F]]" zeigt uns eine kurve, die keine 
wnsche mehr offen lt.
Die brauchbare funktion zur berechnung 
dieser abhngigkeit heit also:

  y=1/(0.101+0.181/x)

Wie "*" vermuten lt, ist es auch 
mglich gewichtete daten zu bearbeiten. 
(D.h. es kommen wertepaare vor, die 
mehr als einmal vorhanden sind. Sie 
beeinflussen die kurvenanpassung 
strker, als wertepaare, die nur einmal 
vorhanden sind.)

Beispiel:
Eine untersuchung von grostadtgebieten 
hat die folgende mittlere anzahl von 
gebuden mit ber 12 stockwerken pro 
gebiet gefunden:

x 150250500750   einwohner in 1000

y   4 10 20 30   hochhuser

n  50 30  6  7   anzahl

Zunchst whlt man regressionsanalyse 
und lscht alte daten mit "Dy". Dann 
gibt man ein:
"150]4]50Z250]10]30Z" ... usw.
Werte die falsch eingegeben wurden, mu 
man sofort lschen indem man den faktor 
(anzahl) wieder eingiebt und "H" 
bettigt und dann DROP DROP ausfhrt, 
damit das falsche wertepaar mit "F" 
nicht zur anzeige gebracht wird. Dann 
macht man wie oben gezeigt weiter. 

Da die graphische anzeige nicht 
bermig viel programmcode 
beanspruchen, aber trozdem einfach in 
der anwendung bleiben sollte, werden 
auftretende fehler global abgefangen. 
Die grahikfunktion versucht dann 
einfach den nchsten punkt zu zeichnen.
Wie weit die anzeige ist, oder ob sie 
hngen geblieben ist, ist aus dem 
untersten balken ersichtlich, der immer 
ber die gesamte breite mitgezeichnet 
wird. Eine anschlieend auftauchende 
fehlermeldung ist einfach zu 
quittieren, und der TOS ist zu 
kontrollieren. Er kann dann verndert 
sein (ich wei noch nicht warum)!

Ein fehler ist auch schnell durch einen 
falsch gewhlten anzeigenbereich 
erzeugt. Deswegen drfen "xmin" und 
"ymin" nicht kleiner als 0 sein.
Wrde man einen x-breich von -5 bis 5 
whlen und die logarithmische 
anpassung, so wre scho der erste wert 
nicht berechenbar.
Zur orientierung folgt eine aufstellung 
alle whlbarer modelle mit x- und 
y-form, namen und den bedingungen, die 
mathematisch nicht rechenbar sind.

   x,    y  - linear
              ohne fehler

 1/x,    y  - hyperbolisch
              fehler wenn x=0

ln(x),   y  - logarithmisch
              fehler wenn x<=0

   x,  1/y  - reziprok
              fehler wenn y=0

 1/x,  1/y  - reziprok-hyperbolisch
              fehler wenn x=0 od. y=0

ln(x), 1/y  - reziprok-logarithmisch
              fehler wenn x<=0 od. y=0

    x,ln(y) - exponentiell
              fehler wenn y<=0

  1/x,ln(y) - exponentiell-hyperbolisch
              fehler wenn x=0 od. y<=0

ln(x),ln(y) - potenz
              fehler wenn x<=0 od. y<=0

Bei negativen x- oder y-werten schlage 
ich vor, alle werte der reihe um einen 
festen betrag anzuheben und dies in die 
ermittelte regressionsformel einzu- 
bauen.



--------------------------------------
         Dauerfunktionen
--------------------------------------

[y] undrop
    setzt den stackpointer um 1 zurck

[x] swap
    vertauscht 1. und 2. stackelement

[c] over
    kopiert das 2. element auf TOS

[b] pick
    kopiert das n-te element auf TOS

[n] cls
    lscht den STACK. Oder genauer:
    Setzt den stackpointer auf 0

[N] clr
    lscht die register. Es werden
    wirklich alle register auf 0
    gesetzt

[tab] info
      Zeigt die infobox an

[esc] quit
      zum verlassen der programms



--------------------------------------
               Anhang
--------------------------------------

Tastatur:

             NUM-Block               .
              -------                .
 ! " # $ % &/ ( ) =? `   shift  .
 1 2 3 4 5 67 8 9 0 '          .
              \      \               .
 Q W E R T ZU I O P *   shift  .
 q w e r t zu i o p +          .
              \       \             .
 A S D F G HJ K L    shift  .
 a s d f g hj k l           .
               \       \             .
  > Y X C V B NM ; : _   shift  .
  < y x c v b nm , . -          .
                 -------             .
                 .
                 .



1. reihe
--------------------------------------
[!] normale belegung
["] statistik belegung
[#] anzeigenbreite des TOS
[$] radian/degree umschaltung
[%]
[&]

2. reihe NORMAL
--------------------------------------
[q] sin            [Q] asin
[w] cos            [W] acos
[e] tan            [E] atan
[r] log            [R] 10^x
[t] ln             [T] e^x
[z] x^2            [Z] x

3. reihe NORMAL
--------------------------------------
[a] fact           [A] interpolieren
[s] store          [S] recall
[d] hr             [D] hms
[f] %ch            [F] %split
[g] R-P            [G] P-R
[h] 1/x            [H] y^x

2. reihe STATISTIK
--------------------------------------
[q] register 1-5   [Q]
[w]                [W]
[e]                [E]
[r] regress-regist.[R] ? - modell
[t] x-register     [T] y-register
[z] x(,y) addieren [Z] x(,y) multipliz.

3. reihe STATISTIK
--------------------------------------
[a] ready          [A]
[s] recall         [S] store
[d] singel data    [D] regression
[f] best modell    [F] graphik
[g] x berechnen    [G] y berechnen
[h] x(,y) subtr.   [H] x(,y) div.

4. reihe
--------------------------------------
[y] undrop
[x] swap
[c] rot
[v] over
[b] pick
[n] cls            [N] clr

diagonale
--------------------------------------
[]   pi
[]   +/-
[]   eex
[e/e] drop



------------ MANUAL ENDE -------------
              (c) 3/95
