          
          
          
          
          
          
          
          
          
          
          
          
                                                     ii
                                                    iiii
                                                     ii
                         sss           cccc             
                       ssssssss      cccccccc      iiiii
                      sss    sss    ccc    ccc     iiiii
                      sssss        ccc               iii
                       sssss       ccc               iii
                          sssss    ccc               iii
                      sss    sss    ccc    ccc       iii
                       ssssssss      cccccccc     iiiiiiiii
                         ssss          cccc       iiiiiiiii
          
          
                             Small C Interpreter
                           Version 1.3 for MS-DOS
                        Copyright (C) 1986 Bob Brodt
          
          
                                User's Manual




























     Small C Interpreter                                      User's Manual


     1. Introduction 


               SCI is a "C" language interpreter loosely based on the 
          language subset described in James Hendrix' "Small C" (see 
          the Appendix "Differences From Small C").  It is a fully 
          interactive interpreter (no compilation!) that includes a 
          powerful full screen editor and a program trace facility.  
          SCI was meant to be a stepping stone for the experienced 
          BASIC programmer who is ready to move up to the exciting 
          world of "C"!  

               SCI will run on any MS-DOS or PC-DOS computer that has 
          a minimum of 64Kbytes of RAM, although 128Kbytes is 
          recommended.  The available free memory (that portion of 
          memory not used by the interpreter's code and data storage) 
          is automatically divided among "user progam code", "variable 
          table", "function table" and "stack" memory segments.  If 
          necessary, the sizes of these segments may be changed at 
          program startup, however their total may not exceed 
          64Kbytes.  

               The integrated full-screen editor does require that the 
          terminal emulation firmware in your computer be capable of 
          recognizing certain terminal control character sequences 
          (also known as "escape sequences") that perform cursor 
          positioning and erasing of portions of the screen.  See the 
          installation instructions in the "Editor" section of this 
          manual.  

               The SCI interpreter is very similar to BASIC 
          internally.  Each line of input is first scanned and 
          "tokenized", a process in which language elements (numbers, 
          variables, keywords, etc.) are converted to one-, two- or 
          three-byte "tokens". These tokens are easier to handle by a 
          computer than arbitrarily long character sequences.  Unlike 
          BASIC however, SCI programs do not require line numbers - 
          the program flow is directed by SCI purely through the 
          structured programming constructs inherent in the "C" 
          language.  This tokenization process allows SCI to run much 
          faster than other interpreters that deal with the raw 
          program text.  However, the "C" language was never designed 
          to be an interpreted programming language like BASIC was, 
          and the price that must be paid for this advantage is in the 
          form of incompatibilities with standard "C" as defined by 
          Kernighan and Ritchie.  


     1.1. This Manual 


               The documentation for SCI is found in the files 


                                     - 1 -


     Small C Interpreter                                      User's Manual


          "USER.MAN" and "PROG.MAN" on the distribution disk.  It is 
          divided into two sections: this, the "User's Manual" and the 
          "Programmer's Manual".  

               If you already have a working knowledge of the C 
          language, the User's Manual is all you need to help you get 
          started quickly with SCI.  It contains a brief overview of 
          SCI's features, a thorough description of the built-in 
          editor with installation instructions, a list of "Library 
          Functions" available to your program and a summary 
          description of SCI's language subset.  The User's Manual 
          also contains a brief description of the SCI symbolic 
          debuger.  In the Appendix you will find quick reference 
          sections that include a complete and terse definition of the 
          language subset supported by SCI, a command summary for the 
          SCI editor and program debuger, and an explanation of SCI 
          error messages.  

               If you are just starting out in learning C, you will 
          most likely want to read the overview section in the User's 
          Manual and then go directly to the Programmer's Manual. The 
          Programmer's Manual is a very introductory tutorial on the C 
          language.  It is designed to be used along with SCI so that 
          you can learn C by experimentation.  If you have a working 
          knowledge of another programming language such as BASIC, you 
          should have no trouble getting through the tutorial.  The 
          Programmer's Manual also contains an introduction to program 
          debuging techniques and full treatment of SCI's built-in 
          debuger.  


     1.2. Starting Out 


               The files on the distribution diskette are: 


               SCI.COM      - the interpreter program
               SHELL.SCI    - the command shell, written in C
               CALC.SCI     - a sample calculator program
               USER.MAN     - User's Manual
               PROG.MAN     - Programmer's Manual


               As always, it is a good idea to make a working copy, 
          and then store your distribution diskette in a safe place.  

               To start up SCI, make sure that SHELL.SCI resides on 
          the current drive and then execute SCI.COM. The interpreter 
          will then read and execute the C program it finds in 
          SHELL.SCI. The program provided for  you in this file 
          contains several items of information needed by the built in 


                                     - 2 -


     Small C Interpreter                                      User's Manual


          editor, as well as some other useful functions.  The program 
          in SHELL.SCI that gets executed by the interpreter is simply 
          an endless loop that prompts you for a line of input from 
          the console and hands it off to the interpreter for 
          execution.  Actually this function could have been performed 
          by the SCI program itself, but by placing this routine 
          outside of the interpreter, you have the option of 
          customizing the interpreter to suit your tastes.  See the 
          section on The Shell in the Programmer's Manual for a 
          detailed discussion of shell functions and customization.  

               You may also specify a different program file for SCI 
          to execute on startup.  By typing the following operating 
          system command line, for example: 


               A>SCI B:STARTUP

          
          the interpreter will search disk B: for a file called 
          STARTUP and execute it in lieu of the default SHELL.SCI 
          file.  Be aware, however, that the standard SHELL.SCI file 
          contains many often-used operating system interface 
          functions that must be copied over to your customized 
          startup program if they are going to be used by that 
          program.  See the section on Library Functions for a list of 
          these functions.  


     1.3. Memory Allocation 


               The interpreter automatically divides up whatever free 
          memory is available (after SCI is loaded) among four 
          segments for use by your programs and data.  These segments 
          are: the Program Code, Variable Table, Function Table and 
          Stack. The Program Code segment contains the tokenized 
          version of your program code.  The Variable Table contains 
          information about all "active" variables.  Each function 
          takes up exactly one entry in the Function Table. Finally, 
          memory requirement for the Stack segment will grow and 
          shrink as your program executes.  The stack is used only for 
          temporary storage when expressions are evaluated.  

               If the interpreter complains about "out of memory", 
          "too many variables", "too many functions" or "stack 
          overflow", you may be able to circumvent the problem by 
          telling SCI how much memory to assign to each of these four 
          segments using the following MS-DOS command line options: 


               -P nnnn - assign "nnnn" decimal bytes for program storage.


                                     - 3 -


     Small C Interpreter                                      User's Manual


               -V nn   - allow space for a maximum of "nn" variables.
               -F nn   - allow space for a maximum of "nn" functions.
               -S nn   - set the stack size to "nn".

          
          Thus, the command line: 


               A>SCI -P 8000 -V 30 -F 80 -S 40

          
          will set aside 8000 bytes for program storage, allow a 
          maximum of 30 variables to be active at one time, allow a 
          maximum of 80 function declarations and leave 40 stack 
          entries.  







































                                     - 4 -


     Small C Interpreter                                      User's Manual


     2. Using the Shell Program 


               The stock version of the "shell program", found in the 
          file SHELL.SCI on your distribution disk, simply displays a 
          prompt on the console, reads a line of input, and attempts 
          to execute the input line.  

               The shell maintains your program in its "program 
          buffer" in memory.  When SCI first starts up, this buffer is 
          empty so you must either create a program using SCI's editor 
          or retrieve a previously created program from disk.  Before 
          you exit from the shell, be sure to save your program on 
          disk or the contents of the program buffer will be lost.  

               The standard shell recognizes four basic (pardon the 
          pun) commands: "edit", "list", "load", "save" and "exit".  
          These are functionally similar to the BASIC commands: 
          "EDIT", "LIST", "LOAD", "SAVE" and "SYSTEM" respectively.  
          Later as you become more familiar with the C language, you 
          may wish to modify the shell program and add your own 
          commands.  

               Anything else typed at the shell prompt is assumed to 
          be a valid C statement and is handed off to the interpreter 
          to be executed.  


     2.1. Shell Commands 


               Listed below are the shell commands.  In the 
          descriptions below, anything enclosed in square brackets ([ 
          and ]) is optional and anything enclosed in angle brackets 
          (< and >) is a verbose description of the item required by 
          the command.  


               edit [<line#>]


               The "edit" command invokes SCI's built-in screen editor 
          (see the Editor section in the User's Manual for more 
          details).  If the word "edit" is followed with a line number 
          (in decimal), the editor will start up by displaying the 
          page of the program that contains the line number, and move 
          the cursor to that line.  If the requested line number is 
          greater than the number of lines in the program buffer, the 
          last page of the program is displayed.  


               list [<from_line#>] [<to_line#>]


                                     - 5 -


     Small C Interpreter                                      User's Manual


               This command lists the program currently in the program 
          buffer on the screen in its entirety.  The listing may be 
          stoped by pressing any key.  If the word "list" is followed 
          by one number, the listing starts at that line number in the 
          program.  If two numbers seperated by one or more spaces 
          follow "list", the program listing will start with the first 
          and end with the second line number in the program.  


               load <filename>


               The "load" command will load the program buffer from 
          the given disk file name.  This command will destroy the 
          current contents of the program buffer.  If the file name is 
          omitted or the file is not found, SCI will display a "file 
          I/O error" message and erase the program buffer.  


               save <filename>


               This will write the contents of the program buffer out 
          to the disk file name.  If the file name is omitted or the 
          file can't be created, SCI displays the "file I/O error" 
          message.  This command does not alter the program buffer in 
          memory.  

               Programs that are "save"d by SCI are ordinary text 
          files, suitable for editing with your favourite text 
          editor.  


               exit


               This command returns you to the MS-DOS command level.  
          If anything was left in the shell's program buffer, it will 
          be lost unless you have previously "save"ed it in a disk 
          file.  


     2.2. Running Your Program 


               A C program is simply a collection of "functions" which 
          (hopefully) all participate to successfully perform a single 
                                                ____                     
          task.  In "standard" C, every program must have one and only 
          one function called "main".  This is where the program will 
          start executing from.  In SCI's C, you need not have a 
                                                        ___            
          "main" function because SCI allows you to run any function 
          in the program buffer by simply typing its name at the SCI 


                                     - 6 -


     Small C Interpreter                                      User's Manual


          input prompt.  Suppose for example that our program buffer 
          contained the following three functions: 


               hex(n)
               {
                    putx(n);
               }
               oct(n)
               {
                    puto(n);
               }
               dec(n)
               {
                    putd(n);
               }


               We could execute any of these functions from the shell 
          by simply typing, for example: 


               > hex(256)


               Note that we showed the shell's greater-than prompt (>) 
          above for demonstration purposes only.  An SCI program is 
          simply a collection of (not necessarily related) functions 
          that can be run and debuged individually or in combination 
          with other functions in the program buffer.  Thus if you 
          plan to transport your program to a compiler, be sure to 
          include a "main" function in the final product.  


     2.3. Program Variables 


                               ______                              
               The interpreter always clears to zero all program 
          variables before each shell statement is executed.  So if 
          you initialize a variable from the shell, the same variable 
          will be set to zero again before the very next C statement 
          entered from the shell.  

               To illustrate, assume we have the following program in 
          the program buffer: 









                                     - 7 -


     Small C Interpreter                                      User's Manual


               int sum;
               
               total(n)
               {
                    sum = sum + n;
               }


               This program uses the variable "sum" to keep a running 
          total of numbers.  However, repeated calls to "total()" from 
          the shell would be futile since the interpreter would always 
          set "sum" to zero before each call.  










































                                     - 8 -


     Small C Interpreter                                      User's Manual


     3. The Editor 

          


     3.1. Introduction 


               SCI's built in editor is screen oriented and is similar 
          to the "standard" set by the popular WORDSTAR word 
          processor.  The editor can be modified to work with almost 
          any personal computer, by simply changing some variables in 
          the shell file (SHELL.SCI).  This section will describe the 
          installation procedure and give needed information for some 
          of the more common personal computers.  


     3.2. Keys 


               The alphabetic character keys on your PC's keyboard are 
          probably arranged in a typewriter keyboard pattern as shown 
          below.  All editing commands (cursor motion, deleting, 
          inserting, etc.) are control-key combinations (i.e. press 
          and hold the CONTROL key and then press a letter key).  In 
          this manual, we will use an up arrow, or circumflex (^) 
          followed by a letter to indicate that the keystroke is a 
          control-key combination.  In the keyboard diagram below, 
          only the letter keys marked with an asterisk (*) are valid 
          editing command control-keys.  What each of these 
          control-keys does will be explained in detail in a later 
          section.  


               ----------------------------------------------
               |                                            |
               | -----------------------------------------  |
               | | Q*| W*| E*| R*| T | Y*| U | I | O | P |  |
               | -----------------------------------------  |
               |   | A*| S*| D*| F*| G*| H*| J | K*| L*|    |
               |   -------------------------------------    |
               |      | Z*| X*| C*| V*| B*| N | M |         |
               |      -----------------------------         |
               |                                            |
               ----------------------------------------------



     3.3. Screen Layout 


               The editor uses all of the screen, except for the last 


                                     - 9 -


     Small C Interpreter                                      User's Manual


          line, as a window into your program.  The last screen line 
          is reserved for status and prompts.  The status line is 
          divided into several fields as shown below: 


                    L:nnnn C:nn  Insert  Mark:nnnn:nnnn
                              |      |     |          |
                              |      |     |     line numbers of start and
                              |      |     |     end of a marked block
                              |      |     |
                              |      |   insert/replace mode indicator
                              |      |
                              |    current column number
                              |
                    current line number


               The current line and column numbers are updated only if 
          you haven't pressed a key within the last two seconds or 
          so.  This lets you enter text or commands at typamatic 
          speeds without slowing you down.  

               If an error should occur while you are editing your 
          program, the status line will be erased and the error 
          message displayed in its place.  You must then hit the 
          <ESCAPE> key to acknowledge that you have seen the error 
          message before you may continue editing.  Also, if the 
          editor needs information from you (such as search strings, 
          etc.) the appropriate prompts will appear in the status 
          line.  


     3.4. Configuration 

          


     3.4.1. Screen Customization 


               Modern computer terminals allow a programmer to 
          manipulate the cursor and text displayed on the screen by 
          means of specific character sequences sent to the terminal.  
          These character sequences are known interchangably as 
          "control codes" or "escape sequences".  

               Most personal computers have a program in ROM that 
          emulates a specific terminal's control codes.  In the case 
          of the IBM PC, this emulation program is a "device driver" 
          program on disk (ANSI.SYS) and must be loaded into RAM when 
          PC-DOS is first booted up (see your IBM PC-DOS manual for 
          installation procedures of this device driver).  


                                     - 10 -


     Small C Interpreter                                      User's Manual


               Your personal computer must have as a minimum, control 
          codes to directly position the cursor anywhere on the 
          screen, and either an "erase to end of line" or "erase to 
          end of screen" control code.  The "erase to end of line" 
          code must clear to spaces all character locations to the 
          right of and including the cursor postion.  The "erase to 
          end of screen" control code performs an "erase to end of 
          line" function and then erases all lines below the current 
          line to spaces.  If your terminal recognizes both of these 
          erase control codes, use "erase to end of screen" in 
          preference of "erase to end of line" because it is slightly 
          faster.  

               If your computer does not provide these minimal control 
          codes, SCI's built in editor can not be used.  In this case, 
          you must resort to using your own text editor to write and 
          modify your programs.  

               Your PC may also have control codes that perform more 
          complicated functions such as inserting and deleting 
          characters and lines.  These are not really necessary, 
          however the editor is designed to take advantage of them if 
          they exist.  You may need to do some experimenting with 
          different combinations of escape sequence to achieve optimum 
          speed performance from the editor.  

               A Terminal's control codes are made known to the SCI 
          editor by way of system global program variables.  These 
          program variables must be declared in your shell program 
                                    ______                           
          file (normally SHELL.SCI) before the "entry" keyword and 
          must be assigned values in the mainline shell program (the 
          function "main" in SHELL.SCI).  There is one variable for 
          each control code.  If your PC does not have a particular 
                                                           ___      
          control code, that corresponding variable should not be 
          declared.  All variables must be declared as character 
          pointers (i.e. char *) with the exception of "_nr", "_nc", 
          "_ro", "_co" and _mhz, which are all char's.  The variable 
          names and their corresponding control code function are 
          listed below: 


                cp                      
               _cp - cursor postion.  

                el                            
               _el - erase to end of line.  

                es                              
               _es - erase to end of screen.  

                dc                                                    
               _dc - delete the character under the cursor and move 
                    left all characters to the right of the cursor.  

                dl                                                      
               _dl - delete the line the cursor is on and move up all 
                    lines below it.  


                                     - 11 -


     Small C Interpreter                                      User's Manual


                ic                                                 
               _ic - insert a character before the one under the 
                    cursor and move all characters to the right.  The 
                           ____                                        
                    cursor must remain at the same position (i.e. at 
                    the inserted character).  

                il                                                       
               _il - insert a line before the one the cursor is on and 
                                                              ____   
                    move all lines below it down.  The cursor must 
                    remain at the same position (i.e. on the newly 
                    created blank line).  

                bl                                                  
               _bl - rings the console bell.  If this variable is 
                    omitted, the standard ASCII BEL character will be 
                    used (octal 007). You may also wish to flash the 
                    screen momentarily to a different color if your PC 
                    has color or reverse video capabilities.  

                nr                                                       
               _nr - number of rows (lines) on the screen.  Typically, 
                    this is set to 24 (25 for the IBM PC).  

                nc                                                     
               _nc - number of columns, usually 80 but may be set to 
                    40 on the IBM PC if you are in 40 column mode.  

                ro                                                   
               _ro - row offset.  The cursor position control code 
                    assumes that the screen "home" position (top left 
                    corner) starts at 0,0.  If this is not the case 
                    for your PC you can add this offset, otherwise 
                    omit this variable.  

                co                                    
               _co - column offset, same as above.  

                mhz                                               
               _mhz - CPU speed (in Megahertz) of your PC. This 
                    variable controls the frequency at which the 
                    editor's status line is updated.  


               As mentioned earlier, the above variables are pointers 
          to characters which should be assigned in your shell 
          mainline program.  The assigned character strings may 
          contain any of the data conversion codes recognized by the 
          Library Function "printf()".  See the section on Sample 
          Configurations (below) for examples.  


     3.4.2. Keyboard Customization 


               In addition, if any of the character pointer variables 
          "_ka", "_kb", ... "_kz" are declared, the string pointed at 
          by these variables is assumed to be the character sequence 
          sent by a function key on your keyboard and will be 
          recognized as an alias of the corresponding control-letter 
          key combination.  


                                     - 12 -


     Small C Interpreter                                      User's Manual


               For example, The VT-100 terminals send the character 
          sequence: "ESCAPE [ A", "ESCAPE [ B", "ESCAPE [ C" and 
          "ESCAPE [ D" for the up, down right and left arrow keys 
          respectively.  So, instead of typing ^E, ^X, ^D and ^S to 
          move the cursor around, we could declare the following 
          variables: 


               char *_ke, *_kx, *_kd, *_ks;
               
               _ke="\033[A";  # alias for ^E
               _kx="\033[B";  # alias for ^X
               _kd="\033[C";  # alias for ^D
               _ks="\033[D";  # alias for ^S

          
          and then use the VT-100's arrow function keys instead.  
          Similarly, other keyboard function keys that transmit 
          multiple characters or single control characters can be used 
          to perform other editor functions.  


     3.5. Sample Configurations 


               This section contains the data declarations and 
          assignments required by some of the more common PC's. The 
          data declarations must be made before the "entry" keyword in 
          SHELL.SCI, and the variable assignments must be done within 
          the function immediately following the "entry" keyword.  For 
          example, look at the configuration for the IBM PC in the 
          distribution version of the SHELL.SCI file: 






















                                     - 13 -


     Small C Interpreter                                      User's Manual


               #
               # Small C Interpreter standard shell
               #
               char _nr, _nc, _ro, _co, *_cp, *_el;
                    .
                    .
                    .
               <Library Function declarations>
                    .
                    .
                    .
               entry
               
               char ln[80];
               char pr[20000];
               
               main()
               {
                    .
                    .
                    .
                    _nr=25;
                    _nc=80;
                    _ro=1;
                    _co=1;
                    _cp="\033[%d;%dH";
                    _el="\033I";
               
                    while ( gets(ln) ) {
                         .
                         .
                         .
                    <main program loop>
                         .
                         .
                         .
                    }
               }


               Only a skeleton of the file is shown here so that you 
          can see the relative locations of the editor variables' 
          declarations and assignments.  Note that the declarations 
                                ______                                
          must appear somewhere before the "entry" keyword, and the 
          control character strings must be assignmed to these 
                              ______                                 
          variables somewhere before the start of the main program 
          loop.  

               In the sample configuration listings below, only the 
          control character strings assignments are shown for 
          brevity.  



                                     - 14 -


     Small C Interpreter                                      User's Manual


     3.5.1. IBM PC 


               The IBM PC is probably the most common.  Note that the 
          ANSI.SYS device driver must be installed for the SCI editor 
          to work.  


               _nr=25;            # the PC has 25 lines
               _nc=80;            # of 80 columns each
               _ro=_co=1;         # row/column numbering starts at 1
               _cp="\033[%d;%dH"; # esc. seq. to position cursor
               _el="\033I";       # esc. seq. to erase to end of line



     3.5.2. DEC Rainbow 100 


               Digital Equipment Corp.s' Rainbow 100 recognizes a 
          subset of the American National Standards Institute (ANSI) 
          Control Sequences for Video Terminals (X3.64).  


               _nr=24;
               _nc=80;
               _ro=1;
               _co=1;
               _cp="\033[%d;%dH"; # position cursor
               _es="\033[J";   # erase to end of screen
               _il="\033[M";   # insert a line
               _ic="\033[4h%c\033[4l"; # insert a character
               _dc="\033[P";   # delete a character
               _bl="\033[?5h\033[?5l"; # bell flashes screen momentarily
               _ke="\033[A";   # up-arrow key
               _kx="\033[B";   # down-arrow key
               _kd="\033[C";   # right-arrow key
               _ks="\033[D";   # left-arrow key



     3.5.3. Heath H19 



               _nr=24;
               _nc=80;
               _ro=' ';
               _co=' ';
               _cp="\033Y%c%c"; # position cursor
               _es="\033E";     # erase to end of screen



                                     - 15 -


     Small C Interpreter                                      User's Manual


     3.5.4. Zenith PC 



               _nr=24;
               _nc=80;
               _ro=' ';
               _co=' ';
               _cp="\033Y%c%c"; # position cursor
               _es="\033E";     # erase to end of screen
               _il="\033L";     # insert line
               _dl="\033M";     # delete line



     3.5.5. Televideo 910 



               _nr=24;
               _nc=80;
               _ro=' ';
               _co=' ';
               _cp="\033=%c%c"; # position cursor
               _el="\033T";     # erase to end of line



     3.6. Editor Commands 


               Now that you have modified the file SHELL.SCI for your 
          particular terminal, you are ready to use the editor.  This 
          section describes all of the editor's commands in detail.  

               All of the editor commands are control-key combinations 
          (press and hold the CONTROL key while pressing a letter 
          key).  We will use an up arrow, or circumflex (^) followed 
          by a letter to indicate that the keystroke is a control-key 
          combination.  All other non-printing keys, such as the 
          <RETURN> and <BACKSPACE> keys, will be in UPPERCASE.  


     3.6.1. Exiting from the Editor 


               To exit the editor and return to the SCI shell, type a 
          ^Z.  






                                     - 16 -


     Small C Interpreter                                      User's Manual


     3.6.2. Cursor Movement 



                E                                                      
               ^E - move cursor up to previous line.  Screen scrolls 
                    down if cursor is at the top of the screen.  

                X                                                       
               ^X - move cursor down to next line.  Screen scrolls up 
                    if cursor is at the bottom of the screen.  

                S                                                      
               ^S - move cursor left one character position.  Cursor 
                    stops at left margin.  

                D                                                       
               ^D - move cursor right one character position.  Cursor 
                    stops at right margin.  

                A                                                    
               ^A - move cursor to beginning of previous "word". A 
                    "word" is defined as a continuous sequence of 
                    alphanumeric characters (i.e. letters and numbers 
                    - no punctuation).  

                F                                             
               ^F - move cursor to beginning of next word.  

                R                                                      
               ^R - move cursor one page (the height of the display) 
                    up towards the beginning of the program.  

                C                                                       
               ^C - move cursor one page down, towards the end of the 
                    program.  

                RETURN  or  LINEFEED                               
               <RETURN> or <LINEFEED> - if the status line shows 
                    "Replace" mode instead of "Insert", these keys 
                    will move the cursor down to the beginning of the 
                    next line.  



     3.6.3. Inserting and Deleting 



                V                                                      
               ^V - toggles Insert/Replace mode.  The status line at 
                    the bottom of the screen will indicate the current 
                    mode.  In Insert mode, any characters you type 
                    will be inserted before the current cursor 
                    position.  In Replace mode, old characters on a 
                    line are simply overwritten as you enter text.  

                G                                                        
               ^G - delete the character under the cursor.  The cursor 
                    stays in the same position.  

                H                                                        
               ^H - delete the character to the left of the cursor and 
                    move the cursor left one character.  


                                     - 17 -


     Small C Interpreter                                      User's Manual


                Y                                                       
               ^Y - delete the current line.  The cursor stays at the 
                    same line.  Note that the <EOF> mark at the end of 
                    the program can not be deleted.  

                L                                                     
               ^L - restore the original line if the cursor has not 
                    been moved off the line.  

                RETURN  or  LINEFEED                               
               <RETURN> or <LINEFEED> - if the status line shows 
                    "Insert" mode, these keys will insert a new blank 
                    line as follows: If the cursor is at line one, 
                    column one (top, left-most column) when a <RETURN> 
                    or <LINEFEED> is pressed, a new blank line is 
                             _____                                      
                    inserted above the current line; everywhere else, 
                                             _____                      
                    the new line is inserted below the current line.  
                    The cursor will rest on the newly inserted line 
                    and directly below the first non-space character 
                    in the previous line.  



     3.6.4. Extended Movement 


               The extended cursor motion commands require two 
          control-key keystrokes.  The first is always a ^Q (mnemonic 
          for Quickly move somewhere), and the second can be one of 
          the following: 


                F                                                      
               ^F - find a character sequence.  The cursor will move 
                    to the status line's prompt/error message field 
                    and you will be prompted for the character 
                    sequence to be searched for.  The search starts at 
                    the next character position to the right of the 
                    cursor on the current line.  When the character 
                    sequence is found, the cursor will rest on the 
                    first character of the sequence.  

                A                                                   
               ^A - find and replace character sequence.  You are 
                    prompted for the character sequence to be searched 
                    for, as above.  Next you are prompted for the 
                    character sequence that will replace the search 
                    string.  Finally, you have the option of 
                    performing the search/replace "globally" that is 
                    for every occurance in the program.  

                L                                                 
               ^L - find next occurence of previously specified 
                    character sequence.  You will not be prompted for 
                    the sequence to be searched for.  

                G                                                       
               ^G - go to a specified line.  You are prompted for the 
                    line number to be displayed.  The cursor will rest 


                                     - 18 -


     Small C Interpreter                                      User's Manual


                    on the requested line usually in the center of the 
                    screen.  

                S                                                
               ^S - move cursor to beginning of current line.  

                D                                          
               ^D - move cursor to end of current line.  

                E                                    
               ^E - move cursor to top of screen.  

                X                                       
               ^X - move cursor to bottom of screen.  

                R                                            
               ^R - move cursor to first line of program.  

                C                                                      
               ^C - move cursor so that the last page of the program 
                    is displayed.  

                B                                                      
               ^B - move cursor to the beginning of a marked block.  

                K                                                
               ^K - move cursor to the end of a marked block.  



     3.6.5. Block and Miscellaneous Commands 


               These commands also require two control-key keystrokes 
          and include block marking, inserting/deleting and some "too 
          late to classify" commands.  

               Unlike the popular WORDSTAR word processor, SCI's 
          editor treats blocks as groups of lines instead of groups of 
          characters.  That is, a block starts at the beginning of a 
          line and includes all characters up to the end of a line.  

               The first of these two-keystroke block commands must be 
          a ^K (mnemonic for blocK (?)) and the second may be one of: 


                B                                                      
               ^B - mark beginning of a block.  The status line will 
                    show the line number of the beginning of the 
                    block.  

                K                                                      
               ^K - mark end of a block.  The status line is updated 
                    to show the end of the block.  

                V                                                        
               ^V - make a copy of a marked block and insert it before 
                    the current line.  You may not copy a block to 
                    itself: for example if the block starts at line 3 
                    and ends at line 10 and the cursor is currently 
                    resting on line 5, you will be severely beeped at 
                    by the editor.  



                                     - 19 -


     Small C Interpreter                                      User's Manual


                Y                               
               ^Y - delete the marked block.  

                U                                                     
               ^U - "unmark" the block.  The block markers (if any) 
                    are removed from the status line display.  

                R                                                   
               ^R - read a file from disk and insert its contents 
                    before the current line in the program.  You will 
                    be prompted for the file name.  

                W                                                      
               ^W - write the marked block to a disk file.  You will 
                    be prompted for the file name.  



     3.6.6. Tabs 


               Tabs are set at every 3 columns.  A ^I (or the <TAB> 
          key on your keyboard if you have one) will either insert 
          spaces or replace with spaces, depending on the current 
          Insert/Replace mode parameter, up to the next tab stop.  

































                                     - 20 -


     Small C Interpreter                                      User's Manual


     4. Language Summary 


               Although SCI implements only a subset of the C 
          language, it is powerful enough to teach you the major 
          principles of C.  This section is meant as a reference for 
          the experienced C programmer that wants to get started with 
          SCI immediately.  


     4.1. Line Terminators 


               In standard C, a statement is typically terminated with 
          a semicolon (;). In SCI, all statements are terminated by 
          either the end of the line or by a semicolon, although the 
          semicolon is optional.  This means that an expression MUST 
          be completely contained on one line.  


     4.2. Comments 


               Comments start with a number symbol (#) and end at the 
          end of the current program line.  The standard C comment 
          delimiters, /* and */ are not recognized and will cause a 
          "syntax error" message.  


     4.3. Identifiers 


               Identifiers may be a maximum of 8 characters long, the 
          first character must be an uppercase or lowercase letter 
          ("a-z", "A-Z") or an underscore ("_"). The remaining 7 
          characters may include digits ("0-9").  

               The following are all examples of valid identifiers: 


               this_is_an_identifier
               _0123
               XYZ



     4.4. Keywords 


               The following words are reserved by SCI and may not be 
          used as variable names: 



                                     - 21 -


     Small C Interpreter                                      User's Manual


               break           entry           return
               char            for             switch
               case            if              sys
               else            int             while


               Most of these keywords are the standard language 
          elements and are described in any C text book.  

               The "entry" keyword is used to tell the interpreter 
          which function in the startup program (normally in the file 
          SHELL.SCI) is to be executed first after the program has 
          been loaded.  There may be only one "entry" within a 
          program.  Any functions or variables that were declared 
          before the "entry" keyword are considered "system globals" 
          and are globally known to all functions.  Among the system 
          globals in the standard shell file are the Library Functions 
          and the editor's control variables.  See the Programmer's 
          Manual for more information on system globals.  

               Functions and variables declared after the "entry" 
          keyword are hidden from user-written functions.  These 
          include the standard shell's control program (main) and its 
          associated variables.  

               The keyword "sys" is a user program interface to some 
          useful interpreter functions, such as the program editor.  
          These are described in the Library Functions section.  


     4.5. Constants 

          


     4.5.1. Numeric Constants 


               SCI supports decimal integer constants in the range 
          -32768 to 32767.  SCI also supports the standard C notation 
          for integer hexadecimal and octal notation.  


     4.5.2. Character Constants 


               A character constant must be surrounded by apostrophes 
          (') and may be one of the following: 


               1) a single ASCII alphanumeric or punctuation (i.e. 
                    printable) character 


                                     - 22 -


     Small C Interpreter                                      User's Manual


               2) a backslash (\) character followed by 3 octal digits 
                    which may be used to represent any 1 byte value 

               3) a backslash followed by one of the characters n, r, 
                    b or t which represent the <LINEFEED> (a.k.a. 
                    "newline"), <RETURN> (carriage return), 
                    <BACKSPACE> and <TAB> characters respectively 


               The following are examples of valid character 
          constants: 


               'A'     the ASCII character "A"
               '\177'  octal character
               '\n'    newline
               '\r'    carriage return
               '\b'    backspace
               '\t'    horizontal tab
               '\\'    the backslash character
               '\''    the apostrophe character



     4.5.3. String Constants 


               Strings may include any of the character constants 
          mentioned above, as for example: 


               "this is a string\007\n"


               Strings always include a null (zero) byte, marking the 
          end of the string.  A zero-length string may be written as 
          two consecutive quotes, thus: "" 


     4.6. Data Types 


               Only the "char" and "int" data types are supported.  
          Characters (char's) are 1 byte and integers (int's) 2 bytes 
          in length.  Both are treated as signed quantities.  Chars 
          may range in value from -128 to +127, ints range from -32768 
          to 32767.  

               SCI also supports pointers and arrays of both char and 
          int.  Pointers require 2 bytes of storage.  




                                     - 23 -


     Small C Interpreter                                      User's Manual


     4.7. Operators 

          


     4.7.1. Unary Operators 


               The following unary operators are supported, all are 
          evaluated from right to left: 


               +--------------------------------+
               | *     pointer                  |
               | &     address                  |
               | -     negation                 |
               | !     logical NOT              |
               | ~     one's complement         |
               | ++    pre- and post-increment  |
               | --    pre- and post-decrement  |
               +--------------------------------+



     4.7.2. Binary Operators 


               The following binary operators are supported, all are 
          evaluated from left to right.  The operators are listed from 
          highest to lowest precedence, by groups (enclosed in 
          boxes).  Each group of operators has the same precedence: 


               +--------------------------------+
               | *     multiplication           |
               | /     division                 |
               | %     modulo (remainder)       |
               +--------------------------------+
               +--------------------------------+
               | +     addition                 |
               | -     subtraction              |
               +--------------------------------+
               +--------------------------------+
               | <<    shift left               |
               | >>    shift right              |
               +--------------------------------+








                                     - 24 -


     Small C Interpreter                                      User's Manual


               +--------------------------------+
               | <     less than                |
               | >     greater than             |
               | <=    less than or equal to    |
               | >=    greater than or equal to |
               +--------------------------------+
               +--------------------------------+
               | ==    equal                    |
               | !=    not equal                |
               +--------------------------------+
               +--------------------------------+
               | &     bitwise AND              |
               +--------------------------------+
               +--------------------------------+
               | ^     bitwise exclusive OR     |
               +--------------------------------+
               +--------------------------------+
               | |     bitwise OR               |
               +--------------------------------+
               +--------------------------------+
               | &&    logical AND              |
               +--------------------------------+
               +--------------------------------+
               | ||    logical OR               |
               +--------------------------------+



     4.7.3. Assignment Operator 


               The assignment operator, "=", is evaluated from from 
          right to left and has lowest precedence of all operators.  


     4.7.4. Comma Operator 


               The Comma Operator (,) as used by SCI is not an 
          operator in the strict sense, but rather a function argument 
          and variable seperator.  Trying to use a comma anywhere 
          other than in function calls, or data declarations will 
          cause a "syntax error".  


     4.8. Program Control Flow Constructs 


               SCI supports the following programming constructs: 


               if ( <expression> ) <statement>


                                     - 25 -


     Small C Interpreter                                      User's Manual


               
               
               if ( <expression> ) <statement> else <statement>
               
               
               while ( <expression> ) <statement>
               
               
               for ( <expression> ; <expression> ; <expression> ) <statement>
               
               
               switch ( <expression> )
               {
               case <constant expression> : <statement>
               case <constant expression> : <statement>
               case <constant expression> : <statement>
                    .
                    .
                    .
               default : <statement>
               }


               All of these constructs require that the keyword ("if", 
          "while", etc.) and its associated ( <expression> ) all 
          appear on the same line of text.  The <statement> portion 
          may appear on the same or on a seperate line of text.  

               If a "default" statement is encountered inside a 
          "switch" before any <constant expression>'s (reading from 
          top to bottom) are found that match the switch <expression>, 
          then execution continues with the <statement> following the 
          "default" keyword.  This is in contrast to standard C that 
                                                      ___         
          only executes the "default" statement after all "case 
          <constant expressions>" have been tested.  



















                                     - 26 -


     Small C Interpreter                                      User's Manual


     5. The Library Functions 


               The "sys" keyword has been reserved by SCI as a means 
          of communicating between a user's program and the 
          interpreter.  It is treated exactly as a (pre-defined) 
          function that may be referenced by a user program.  

               A "sys" call may have several arguments, the number and 
          type of which depends upon the integer value of the last 
          (right-most) argument.  This right-most argument is called 
          the "sys number" and defines the actual function performed 
          by a "sys" call.  To make life easier and to provide a more 
          or less "standard" programming environment, higher- level 
          functions have been wrapped around these "sys" calls - these 
          are known as the "Library Functions" and may be found in the 
          standard command shell included in the distribution disk.  
          The "sys numbers" and their corresponding mnemonic name are 
          listed below.  


               0       version
               1       fputc
               2       fgetc
               3       fputs
               4       fgets
               5       sprintf
               6       sscanf
               7       fopen
               8       fread
               9       fwrite
               10      fclose
               11      fseek
               12      ftell
               13      bdos
               14      system
               15      exit
               16      stmt
               17      totok
               18      untok
               19      edit
               20      strcmp and strncmp
               21      strcpy and strncpy
               22      strlen
               23      malloc
               24      free
               25      load
               26      save
               27      list
               28      trace
               29      dirscan



                                     - 27 -


     Small C Interpreter                                      User's Manual


               The Library Functions are described below in more 
          detail.  Some of the "sys" functions do not have a 
          corresponding Library Function interface in SHELL.SCI, but 
          are described here anyway for completeness.  


     5.1. atoi 

          
          atoi( string ) 
          char *string; 

               Converts the string "str" containing the ASCII 
          representation of a decimal number to an integer.  The 
          string consits of optional leading spaces or tabs, an 
          optional plus or minus sign (+ or -) followed by one or more 
          decimal digits.  Returns the integer value of the ASCII 
          number string.  

               This function does not have a "sys" call number 
          equivalent but rather it uses the "sscanf" Library 
          Function.  


     5.2. bdos 

          
          bdos( cx, dx ) 
          int cx, dx; 

               Performs a call on the operating system's BDOS. The 
          arguments "cx" and "dx" will be copied to the machine's CX 
          and DX registers respectively before the BDOS call.  The 
          function returns the value of the CPU's AX register after 
          the call.  See your MS-DOS programmer's manual for more 
          details on BDOS calls.  


     5.3. dirscan 

          
          dirscan( afn, file ) 
          char *afn, file[20]; 

               This function will scan the disk directory for file 
          names that match the "ambiguous file name" given by the 
          string "afn". Ambiguous file names may contain "*" and "?"  
          wildcard characters as explained in your MS-DOS manual.  The 
          first file name found in the directory that matches will be 
          copied into the buffer at "file". To continue the directory 
          scan and search for the next matching file name, set "afn" 
          equal to zero.  Dirscan will return a 1 if a matching file 


                                     - 28 -


     Small C Interpreter                                      User's Manual


          name was found, zero if not.  


     5.4. edit 

          
          edit( line_num, program ) 
          int line_num 
          char *program 

               Invokes the built-in program editor, starting at the 
          line given by "line_num" on the tokenized program buffer 
          "program". Returns the new size of the program buffer after 
                                ____ ________ __ ___ ________ __   
          the editing session.  This function is not included in 
          _____ ___   
          SHELL.SCI 


     5.5. exit 

          
          exit( value ) 
          int value 

               Causes the currently executing program to return 
          control to the operating system.  The number "value" is 
          returned to the operating system shell (usually COMMAND.COM 
          in MS-DOS).  


     5.6. fclose 

          
          fclose( channel ) 
          int channel; 

               Closes a disk file previously opened by the Library 
          Function "fopen". Returns zero if successful, -1 on error.  


     5.7. fgetc 

          
          fgetc( channel ) 

               Reads a single character from the given channel.  
          Returns the character read, or a -1 on error or end of 
          file.  







                                     - 29 -


     Small C Interpreter                                      User's Manual


     5.8. fgets 

          
          fgets( buffer, length, channel ) 
          char *buffer; 
          int length; 
          int channel; 

               Reads characters from the file associated with 
          "channel".  Characters are read from the file until either a 
          newline is encountered, length minus 1 characters have been 
          read, or an end of file is found.  Returns the address of 
          "buffer", or a zero on end of file.  


     5.9. fopen 

          
          fopen( file_name, mode ) 
          char *file_name, *mode; 

               Opens a disk file whose name is given by the string 
          "file_name".  The string "mode" determines how the file will 
          be opened: 


                r                                                   
               "r" - open for ASCII read.  The file MUST exist or 
                    fopen returns an error code.  

                rw                                                
               "rw" - open for ASCII read/write.  The file MUST 
                    exist.  

                w                                                       
               "w" - open for ASCII write.  If the file exists, it is 
                    first deleted.  

                wr                                                      
               "wr" - open for ASCII read/write.  If the file already 
                    exists, it is first deleted.  

                a                                                     
               "a" - open for ASCII write append.  If the file does 
                    not exist, it is created.  If it does exist, the 
                    file position pointer is positioned to the end of 
                    the file.  

                ar                                                     
               "ar" - open for ASCII read/write append.  If the file 
                    does not exist it is created.  If it DOES exist, 
                    it is opened and the file pointer positioned to 
                    the end of the file.  The file may then be read or 
                    written.  


               By appending a "b" to any of the modes above, the file 
          is opened in BINARY mode instead of ASCII.  


                                     - 30 -


     Small C Interpreter                                      User's Manual


               When a file is opened in ASCII mode, all <LINEFEED>s 
          ("\n") are converted to <RETURN> <LINEFEED> character pairs 
          when writing to the file.  Similarly, <RETURN> <LINEFEED> 
          pairs are converted to a single <LINEFEED> character on 
          input from the file.  

               In BINARY read/write mode, no such conversions are 
          performed.  

               Returns an integer value known as a "channel". The 
          special channels 0, 1 and 2 refer to the standard input, 
          standard output and standard error files, and are initially 
          set for I/O on the console.  The channel number must be used 
          in all Library calls that perform file I/O functions.  A 
          Minus one is returned if the file could not be opened.  


     5.10. fputc 

          
          fputc( c, channel ) 
          char c; 
          int channel; 

               Writes the character "c" to the specified file 
          channel.  Returns the character written, or a -1 on error.  


     5.11. fputs 

          
          fputs( string, channel ) 
          char *string; 
          int channel; 

               Writes the string to the specified file channel.  
          Returns zero, or a -1 on error.  


     5.12. fread 

          
          fread( buffer, length, channel ) 
          char *buffer; 
          int length; 
          int channel; 

               Reads a maximum of "length" bytes into memory at the 
          address pointed to by "buffer" from the open file, 
          "channel". If the file was opened in ASCII read or 
          read/write mode, "fread" only reads up to and including a 
          newline character.  If the file was opened in binary read 


                                     - 31 -


     Small C Interpreter                                      User's Manual


          mode, "length" number of characters are read if they are 
          available.  Note that "channel" must be the value returned 
          from a previous "fopen" Library Function call, and the file 
          must still be open.  Returns the number of characters that 
          were actually read, or 0 on EOF.  


     5.13. free 

          
          free( memory ) 
          char *memory 

               Returns to the memory pool the block of memory pointed 
          to by "memory" that was previously gotten from a "malloc" 
          Library Function call.  


     5.14. fseek and ftell 

          fseek( channel, offset, whence ) 
          int channel, offset, whence; 
          
          ftell( channel ) 

               These functions manipulate a file's position pointer.  
          The file position pointer determines where in the file the 
          next byte of data will be read from or written to.  The 
          argument "channel" is the file channel number; "offset" is a 
          byte position offset; "whence" determines how the "offset" 
          will be applied to the current file position pointer.  If 
          "whence" is zero, "fseek" will move the file position 
                                             _________                 
          pointer to "offset" bytes from the beginning of the file.  
          If "whence" is one, "fseek" will move the file position 
                                             _______ ________           
          pointer to "offset" bytes from its current location, either 
          forward ("offset" is positive) or backward ("offset" is 
          negative) in the file If "whence" is two, "fseek" will move 
                                                               ___      
          the file position pointer to "offset" bytes from the end of 
          the file.  In this case, "offset" must be negative to move 
          the file position pointer towards the beginning of the 
          file.  

               Ftell simply returns the current file position.  



                                        NOTE   
                                        NOTE:

               Because SCI supports only integer variables, these 
               functions  may  only  be  used  on  files that are
               smaller than 32767 characters.  Standard C  allows
               you to manipulate much larger files.  


                                     - 32 -


     Small C Interpreter                                      User's Manual


     5.15. fwrite 

          
          fwrite( buffer, length, channel ) 
          char *buffer; 
          int length; 
          int channel; 

               Writes "length" number of characters from memory at the 
          address pointed to by "buffer" to the file associated with 
          "channel".  Note that "channel" must be the value returned 
          from a previous "fopen" Library Function call, and the file 
          must still be open.  Returns the number of characters 
          actually written if successful, or a -1 on error.  


     5.16. load 

          
          load( file, program ) 
          char *file, *program 

               Loads a program from the file whose name is pointed at 
          by "file", tokenizes the statements therein and places the 
          tokenized program at "program". Returns the size of the 
          resulting tokenized program.  If the file could not be 
                                                              ____   
          found, an error message is printed on the console.  This 
          ________ __ ___ ________ __ _____ ___   
          function is not included in SHELL.SCI 


     5.17. malloc 

          
          malloc( size ) 
          int size 

               Main memory allocator.  This function is responsible 
          for handing out (to programs) chunks of free memory to be 
          used by the program as it sees fit.  


                                    WARNING   
                                    WARNING:

               wreckless programs that write data beyond the size 
               of  the  allocated  chunk of memory will cause the
               allocator to loose its mind and dole out  "rotten"
               chunks of  memory.   This will almost surely cause
               SCI to crash and burn.  Returns  a  pointer  to  a
               block of  memory  "size"  bytes  long.  Be sure to
               de-allocate the block using the  Library  Function
               "free"  when  you're  done  with it, or it will be
               lost forever...    Also,  do  not  use  malloc  to


                                     - 33 -


     Small C Interpreter                                      User's Manual


               allocate  memory  for  SCI program buffers, or you
               will surely crash the system.  



     5.18. printf 

          
          printf( format, arg1, arg2, ... arg8 ) 
          char *format; 
          int arg1, arg2, ... arg8; 

               Prints a formatted string to the standard output file.  
          The characters in the string "format" are copied to the 
          standard output file.  If a percent character ("%") is 
          encountered in the format string, it is assumed to be a 
          conversion specification.  Each conversion specification 
          converts exactly one argument in the list "arg1", "arg2", 
          ... "arg8". Once an argument has been converted and output, 
          it is skipped over the next time a conversion specification 
          is encountered.  Therefore, you need just as many arguments 
          as you have conversion specifications (%-somethings).  

               The character(s) that follow a conversion specification 
          may be one or more of the following: 


               minus sign                                              
               minus sign (-) - Indicates that output should be left 
                    justified instead of right justified.  

               zero fill character  0                                  
               zero fill character (0) - The field will be padded on 
                    the left with zeros.  

               field width  number other than 0                          
               field width (number other than 0) - This is the minimum 
                    # of characters output.  The field will be padded 
                    with zeros or blanks depending on the fill 
                    character (above).  

               precision    followed by a number                  
               precision (. followed by a number) - For numeric 
                    fields, this is the # of decimal places to the 
                    right of the decimal point.  For string fields, at 
                    most that many characters of the string will be 
                    output.  

               conversion code  the letter d  u  x  o  b  s or c        
               conversion code (the letter d, u, x, o, b, s or c) - A 
                    conversion code indicates the type of conversion 
                    that is to be done on the argument as follows: 


                         d - convert to a decimal (base 10) number
                         u - unsigned decimal number
                         x - hexadecimal (base 16) number


                                     - 34 -


     Small C Interpreter                                      User's Manual


                         o - octal (base 8) number
                         b - binary (base 2) number
                         s - string constant
                         c - single ASCII character




     5.19. save 

          
          save( file, program ) 
          char *file, *program 

               Saves a program in its tokenized form at "program" to 
          the file whose name is in the string "file". Returns the 
          number of bytes written to the file.  If the file could not 
          be created, an error message is printed on the console.  
          ____ ________ __ ___ ________ __ _____ ___   
          This function is not included in SHELL.SCI 


     5.20. scanf 

          
          scanf( format, arg1, arg2, ... arg8 ) 
          char *format 
          int arg1, arg2, ... arg8 

               Reads characters from the standard input file and 
          converts them using the conversion string "format" (same as 
          for Library Function "printf"). The arguments "arg1", 
                                     ________                           
          "arg2", ... "arg8" must be pointers to the appropriate data 
          types.  


     5.21. sprintf 

          
          sprintf( buffer, format, arg1, arg2, ... arg8 ) 
          char *buffer, *format 
          int arg1, arg2, ... arg8 

               Performs formated conversion of the arguments, exactly 
          like the Library Function "printf()", but writes its output 
          to the "buffer" instead of the standard output file.  


     5.22. sscanf 

          
          sscanf( buffer, format, arg1, arg2, ... arg8 ) 
          char *buffer, *format 


                                     - 35 -


     Small C Interpreter                                      User's Manual


          int arg1, arg2, ... arg8 

               Performs formated input conversion of the arguments, 
          exactly like the Library Function "scanf()" but reads its 
          input from the "buffer" instead of the standard input file.  


     5.23. stmt 

          
          stmt( line, program ) 
          char *line, *program 

               Hands a C statement off to the interpreter for 
          execution.  The statement is in its untokenized form at 
          "line". The program, also in tokenized form, at "program" is 
          used by the interpreter to satisfy any global variable or 
                                                      ____ ________ __   
          function references made by the statement.  This function is 
          ___ ________ __ _____ ___   
          not included in SHELL.SCI 


     5.24. strcmp, strncmp 

          
          strcmp( string_1, string_2 ) 
          char *string_1, *string_2 
          
               or 
          
          strncmp( string_1, string_2, limit ) 
          char *string_1, *string_2 
          int limit 

               Compares (character-by-character) the two strings.  The 
          comparison stops when a zero is encountered in either of the 
          two strings.  "strncmp" does the same thing, but at most 
          "limit" number of bytes are compared.  Returns a 0 if the 
          two strings are identical, non- zero if they differ.  


     5.25. strcpy, strncpy 

          
          strcpy( string_1, string_2 ) 
          char *string_1, *string_2 
          
               or 
          
          strncpy( string_1, string_2, limit ) 
          char *string_1, *string_2 
          int limit 



                                     - 36 -


     Small C Interpreter                                      User's Manual


               Copies (character-by-character) "string_2" into 
          "string_1".  The functions stops after the first null 
          character is encountered in "string_2".  "strncpy" does the 
          same thing, but at most "limit" number of bytes are copied.  
          Returns nothing interesting.  


     5.26. strlen 

          
          strlen( string ) 
          char *string; 

               Returns the number of characters in the given string, 
          excluding the string's trailing zero byte.  


     5.27. system 

          
          system( command_string ) 
          char *command_string; 

               Executes the MS-DOS command interpreter (usually the 
          program in COMMAND.COM) and passes it the MS-DOS command 
          found in "command_string".  SCI remains suspended in memory 
          in its current state and will continue execution when the 
          command has completed.  The return value from "system" is 
          the completion status of the MS-DOS program, which may be 
          used to test for success or failure.  


     5.28. totok 

          
          totok( sourcebuf, tokenbuf ) 
          char *sourcebuf, *tokenbuf 

               Converts the C statement at "sourcebuf" to its 
          tokenized equivalent and places the result at "tokenbuf". 
                                             ____ ________ __ ___   
          Returns the length of "tokenbuf".  This function is not 
          ________ __ _____ ___   
          included in SHELL.SCI 


     5.29. trace 

          
          trace( on_off ) 
          int on_off; 

               Allows a program to enable or disable the SCI debuger.  
          If "on_off" is zero, the debuger is disabled, anything else 


                                     - 37 -


     Small C Interpreter                                      User's Manual


          enables it.  


     5.30. untok 

          
          untok( tokenbuf, sourcebuf ) 
          char *tokenbuf, *sourcebuf 

               Converts the tokenized statement at "tokenbuf" to its 
          printable form at "sourcebuf". Returns the length of 
          "tokenbuf" (not "sourcebuf"!). This function is the opposite 
                                    ____ ________ __ ___ ________ __   
          of the "totok" function.  This function is not included in 
          _____ ___   
          SHELL.SCI 


     5.31. version 

          
          version() 

               Returns a character string that contains SCI's program 
          identification and copyright notice, and the program's 
          current version number, namely the string: 
         Small C Interpreter V1.3 15Mar86 Copyright (C) 1986 Bob Brodt





























                                     - 38 -


     Small C Interpreter                                      User's Manual


     6. The Debuger 


               The Library Function "trace()" allows you to enable or 
          disable the SCI debuger.  When the debuger is enabled, you 
          can set and remove breakpoints, examine and modify program 
          variables and control the execution of your program.  

               When the debuger is enabled, it first displays each 
          line of the program on the console before it is executed, 
          followed by a question mark (?) prompt.  At this point, you 
          may either enter another valid C statement (to display the 
          contents of a variable for example), or enter one of the 
          following commands (NOTE: all of these commands must start 
          with a dot (.) immediately following the "?"  prompt to 
          distinguish them from a valid C statement): 


               b                                                
               b# - sets a breakpoint at a given line in your 
                    program.  The "#" symbol represents the line 
                    number at which the program will be halted.  

               B                                                   
               B - displays all breakpoints set in the program.  

               c                                                
               c - continues program execution until the next 
                    breakpoint is encountered.  

               d                                                     
               d# - deletes the breakpoint at line number "#". The 
                    breakpoint must have been previously set with a 
                    ".b" command.  

               D                               
               D - deletes all breakpoints.  

               e                                                    
               e# - lets you examine the program with the program 
                    editor.  Editor commands that would normally 
                    modify the program are disabled.  

               g                                                        
               g - displays all of the program's global variables and 
                    their values.  If the variable is an array, its 
                    address is printed followed by the first 10 
                    elements of the array.  

               G                                                      
               G - same as ".g" but also displays the first line of 
                    every function in the program along with its line 
                    number.  This is useful for locating a function in 
                    a long program.  

               q                                                      
               q - quits program execution and returns to the shell 
                    program.  

               s                                                        
               s# - steps through the program without displaying each 
                    line as it is executed.  The "#" is the number of 


                                     - 39 -


     Small C Interpreter                                      User's Manual


                    lines to be executed before control returns to the 
                    debuger.  

               t                                                    
               t - displays the list of active functions with the 
                    current one at the top of the list.  This is handy 
                    for finding out "how did I get here?".  

               T                                                    
               T - same as ".t" but also displays each function's 
                    local variables and their values.  

                RETURN                        
               <RETURN> - same as a ".s1".  

                ESCAPE                                                 
               <ESCAPE> - is used to interrupt a program while it is 
                    running and enable the debuger.  


               If the SCI interpreter finds an error in your program, 
          it will automatically enable the debuger and halt the 
          program at the line where the error occurred.  This can be a 
          little confusing if you are already in the debuger and you 
          happen to make a mistake while typing a statement for the 
          debuger to execute, because the resulting error message and 
          the "?"  prompt will refer to the statement you just 
          entered.  If this happens, just hit a <RETURN> and you will 
          be returned to the program debug session.  





























                                     - 40 -


     Small C Interpreter                                      User's Manual


     7. APPENDIX A: SCI Language Syntax 


               This appendix contains what is known as the 
          "Backus-Naur Form", or "BNF" of the SCI language.  Named 
          after its inventors, BNF is a very precise description of a 
          language and is useful as a reference for proper syntax.  
          The BNF of a language may at first be a little confusing, 
          but with practice it can be a very natural way of expressing 
          the syntax structure of any language.  

               The following rules apply to the BNF notation in this 
          appendix: 


               1) words that appear in UPPER CASE represent key 
                    elements of the language like the "IF" and "WHILE" 
                    keywords, or like the symbol for multiplication 
                    (*). These types of words are known as "TERMINALS" 
                    and, like atoms, they can not be broken into 
                    smaller parts.  

               2) Words in "lower case" represent what are called 
                    "non-terminals" and, as their name implies, they 
                    may consist of other smaller elements; either 
                    TERMINALS or non-terminals.  

               3) the word to be defined will appear on a line by 
                    itself, followed by a colon (:) followed by its 
                    definitions indented below it.  

               4) within a definition, language elements are seperated 
                    by a space.  

               5) depending upon its context, a language element may 
                    not appear at all and its definition is the 
                    special "empty" definition.  

               6) the SCI-style comment mark (#) is used only to 
                    clarify a definition and is not part of the 
                    definition 


               We have always been taught never to use a word we are 
          defining in its definition, that "recursive definitions" are 
          blasphemous!  However when defining language syntax it is 
          often desirable, indeed necessary, to use recursive 
          definitions.  Take for example the BNF description of a word 
          in the english language: a word may be one or more letters 
          strung together.  More formally, 




          APPENDIX                   - 41 -


     Small C Interpreter                                      User's Manual


               a "word": may be either:
                    1. a "letter", or
                    2. a "word" followed by a "letter"


               Here we can deduce definition number 2 because the 
          first letter of a word qualifies as a word itself, according 
          to our definition 1.  Even more formally, 


               word:
                    LETTER       # for example the word "a"
                    word LETTER  # for example the word "as"


               We have written "LETTER" in upper case to indicate that 
          a letter can not be broken down any further, i.e.  it is a 
          "TERMINAL". Similarly, "word" appears in lower case because 
          it can be broken down into smaller parts; it is a 
          "non-terminal".  

               Here then, is the BNF of the SCI language.  Assume that 
          you already know what the terminals LETTER (one of: a b 
          c...z, or A B C...Z, or _), NUMBER (one of: 0 1 2...9), 
          HEXDIGITS (0 1 2...9 A B...F) and OCTALDIGITS (0 1 2...7) 
          are.  


               id-list:           # identifier (variable) list
                    empty         # may be non-existent
                    id            # or a single identifier
                    id-list , id  # or two or more id's seperated by a comma
               
               id:                # an identifier (variable)
                    LETTER
                    id LETTER
                    id NUMBER
               
               hex-constant:      # hexadecimal constant
                    0 X HEXDIGITS
               
               oct-constant:      # octal constant
                    0 OCTALDIGITS
               
               dec-constant:      # decimal constant
                    NUMBER
                    constant NUMBER
               
               chr-constant:      # character constant
                    ' CHARACTER '
               
               str-constant:      # string constant


          APPENDIX                   - 42 -


     Small C Interpreter                                      User's Manual


                    " CHARACTER-LIST "
               
               constant:          # constants 'R' all of the above
                    dec-constant
                    hex-constant
                    oct-constant
                    chr-constant
                    str-constant
               
               expression-list:
                    empty
                    expression
                    expression-list , expression
               
               expression:
                    primary
                    * expression
                    & lvalue
                    ++ lvalue
                    -- lvalue
                    lvalue ++
                    lvalue --
                    - primary
                    + primary
                    ! expression
                    ~ expression
                    expression binop expression
                    lvalue = expression
               
               primary:
                    id
                    constant
                    string
                    ( expression )          # a parenthesized expression
                    id ( expression-list )  # a function call
                    id [ expression ]       # an array element
               
               lvalue:
                    id                      # a simple variable
                    id [ expression ]       # an array element
                    * expression            # a pointer expression
               
               binop:             # the binary operators:
                    *
                    /
                    %
                    +
                    -
                    <<
                    >>
                    <
                    <=


          APPENDIX                   - 43 -


     Small C Interpreter                                      User's Manual


                    >
                    >=
                    ==
                    !=
                    &
                    ^
                    |
                    &&
                    ||
               
               declaration-list:
                    empty
                    declaration
                    declaration-list declaration
               
               declaration:
                    type-spec declarator-list ;
               
               type-spec:
                    CHAR
                    INT
               
               declarator-list:
                    declarator
                    declarator-list , declarator
               
               declarator:
                    id
                    id [ constant ]
                    * id
               
               statement-list:
                    statement
                    statement-list statement
               
               compound-statement:
                    { declaration-list statement-list }
               
               statement:
                    ;                  # a no-op statement
                    compound-statement
                    expression ;
                    IF ( expression ) statement
                    IF ( expression ) statement ELSE statement
                    SWITCH ( expression ) statement
                    CASE constant : statement
                    DEFAULT : statement
                    BREAK ;
                    WHILE ( expression ) statement
                    FOR ( expression ; expression ; expression ) statement ;
                    RETURN ;
                    RETURN expression ;


          APPENDIX                   - 44 -


     Small C Interpreter                                      User's Manual


               
               function:
                    id ( id-list ) declaration-list compound-statement
               
               function-list:
                    empty
                    function
                    function-list function
               
               program:
                    empty
                    declaration-list
                    function-list
                    program declaration-list
                    program function-list







































          APPENDIX                   - 45 -


     Small C Interpreter                                      User's Manual


     8. APPENDIX B: Editor Command Summary 



                Z          
               ^Z - exit 

                E               
               ^E - cursor up 

                X                 
               ^X - cursor down 

                S                 
               ^S - cursor left 

                D                  
               ^D - cursor right 

                A                                    
               ^A - cursor to end of previous word 

                F                                        
               ^F - cursor to beginning of next word.  

                R             
               ^R - page up 

                C               
               ^C - page down 

                RETURN  or  LINEFEED                              
               <RETURN> or <LINEFEED> - Replace Mode: cursor to 
                    beginning of next line Insert Mode: append blank 
                    line after current line 

                V                                
               ^V - toggle Insert/Replace Mode 

                G                                   
               ^G - delete character under cursor 

                H or  BACKSPACE                                         
               ^H or <BACKSPACE> - delete character to left of cursor 

                Y                 
               ^Y - delete line 

                L                  
               ^L - restore line 

                Q F                 
               ^Q^F - find string 

                Q A                             
               ^Q^A - find and replace string 

                Q L                                   
               ^Q^L - find next occurance of string 

                Q G                
               ^Q^G - go to line 

                Q S                                 
               ^Q^S - cursor to beginning of line 

                Q D                           
               ^Q^D - cursor to end of line 

                Q E                             
               ^Q^E - cursor to top of screen 

                Q X                                
               ^Q^X - cursor to bottom of screen 



          APPENDIX                   - 46 -


     Small C Interpreter                                      User's Manual


                Q R                              
               ^Q^R - cursor to top of program 

                Q C                              
               ^Q^C - cursor to end of program 

                Q B                                  
               ^Q^B - cursor to beginning of block 

                Q K                            
               ^Q^K - cursor to end of block 

                K B                             
               ^K^B - mark beginning of block 

                K K                       
               ^K^K - mark end of block 

                K V                  
               ^K^V - insert block 

                K Y                  
               ^K^Y - delete block 

                K U                  
               ^K^U - unmark block 

                K R                         
               ^K^R - read from disk file 

                K W                              
               ^K^W - write block to disk file 

































          APPENDIX                   - 47 -


     Small C Interpreter                                      User's Manual


     9. APPENDIX C: Debuger Command Summary 

          All debuger commands start with a dot (.) as the first 
          character in the command to distinguish them from valid C 
          statements.  


               b                                            
               b# - set a breakpoint at line number "#".  

               B                                   
               B - display all breakpoints set.  

               c                                                     
               c - continue program execution to next breakpoint.  

               d                                             
               d# - delete breakpoint at line number "#".  

               D                              
               D - delete all breakpoints.  

               e                                            
               e# - examine program with the SCI editor.  

               g                                                   
               g - display global variables and their contents.  

               G                                                     
               G - same as ".g" but also display the first line of 
                    every function in the program.  

               q                                
               q - quit and return to shell.  

               s                                                    
               s# - step "#" lines without displaying each line.  

               t                                        
               t - display function call back trace.  

               T                                                    
               T - same as ".t" but also displays each function's 
                    local variables and contents.  

                RETURN                       
               <RETURN> - same as ".s 1".  

                ESCAPE                                                  
               <ESCAPE> - interrupts an executing program and enables 
                    debuger.  

















          APPENDIX                   - 48 -


     Small C Interpreter                                      User's Manual


     10. APPENDIX D: Differences From Small C 


               SCI supports the subset of the C language defined by J. 
          Hendrix' public domain "Small C" compiler, available for 
          many CP/M and MS-DOS machines.  There are, however, some 
          minor differences that have been dictated in part by the 
          fact that this is an interpreter.  These are: 


               1) Program source lines are limited to 80 characters, 
                    just to keep things simple.  The editor will 
                    complain if you try to create a line longer than 
                    80 characters.  

               2) There are no #define or #include statements, simply 
                    because there is no pre-processor!  

               3) Comments are introduced by the number symbol (#) and 
                    are terminated by the end of the line.  The "/*" 
                    and "*/" combinations will only be barfed at by 
                    SCI.  

               4) Statements in general are terminated by the end of a 
                    line - the semicolon required by the C language at 
                    the end of a statement is superfluous.  This 
                    restriction imposes that an expression be 
                    completely on one line (boooo, hissss!), however 
                    you no longer get penalized for forgeting a 
                    semicolon (hurray, yay!).  This also implies that 
                    string and character constants are terminated by 
                    the end of the line.  In fact, if you forget to 
                    add the terminating quote or apostrophe delimiter, 
                    SCI will append one for you.  

               5) Data variable initialization is not supported by 
                    SCI.  

               6) Local data variables declared inside a compound 
                    statement within a function may not have the same 
                    name as a previously declared local variable.  A 
                    "variable already declared" error will result.  
                    All other scope rules apply.  

               7) Pointer arithmetic is not smart enough to recognize 
                    data types so that pointers to integers are 
                    advanced to the next BYTE, not the next integer.  
                    For example, *(ip+1) will point to the least 
                    significant byte of the next integer (on an 8086 
                    machine), not the next word (booo, hisss!).  But, 
                    ip[1] and ++ip still point to the next integer 
                    (whew!).  Also, SCI allows does not restrict 


          APPENDIX                   - 49 -


     Small C Interpreter                                      User's Manual


                    pointer arithmetic to just addition and 
                    subtraction, like standard C does.  

               8) The logical AND and OR operators (&& and ||) 
                    evaluate both of their operands, unlike standard C 
                    which stops evaluation once the truth or falsehood 
                    of an expression is known.  

               9) The comma operator is recognized only when used in 
                    function calls and data declarations.  For 
                    instance, it would be illegal to say: while ( 
                    argv++, argc-- ); 

               10) The "default" statement inside a "switch" is 
                    executed as soon as it is encountered (when 
                    scanning from the top to the bottom of the 
                    "switch"). SCI is too lazy to do an exhaustive 
                    test of all "case"s before executing the 
                    "default", so be sure to place all "default"s as 
                    the last statement in the "switch".  


































          APPENDIX                   - 50 -


     Small C Interpreter                                      User's Manual


     11. APPENDIX E: Error Messages 


               When SCI detects an error in your program, it will stop 
          execution, display an error message and then the line number 
          and program text of the offending line.  The SCI debuger is 
          then automatically enabled.  The possible error messages are 
          listed below: 


               no entry point                                    
               no entry point - You forgot to specify an entry 
                    function with the "entry" keyword.  

               not enough table space                                 
               not enough table space - There was insufficient free 
                    memory available for the shell program, variable, 
                    function and stack segments.  Specify a smaller 
                    -P, -V, -F or -S value.  

               file I O error                                          
               file I/O error - The specified program file could not 
                    be loaded, or SHELL.SCI does not exist on the 
                    default disk drive.  Or, the specified file could 
                    not be save on disk because of an operating system 
                    error.  

               missing                                                  
               missing '}' - The interpreter wandered off the edge of 
                    your program because you forgot a closing brace.  

               missing operator                               
               missing operator - The interpreter found two 
                    consecutive operands as for example the statement: 
                    var 3; 

               missing     or                                   
               missing ')' or ']' - Mismatched left and right 
                    parentheses or brackets were detected.  

               not a pointer                                           
               not a pointer - A simple "char" or "int" variable was 
                    used as an array or pointer.  

               syntax error                                            
               syntax error - An error was detected in the structure 
                    of a statement or function.  

               lexical error                                         
               lexical error - An illegal character was found in a 
                    statement.  

               need an lvalue                                           
               need an lvalue - An attempt was made to assign a value 
                    to a constant or an array variable.  

               stack underflow                                      
               stack underflow - Something is wrong!  Contact the 
                    author.  

               stack overflow                                      
               stack overflow - The expression is too complex or 
                    function calls are nested too deeply.  Try 
                    specifying a larger -S value when starting up 


          APPENDIX                   - 51 -


     Small C Interpreter                                      User's Manual


                    SCI.  

               too many functions                                
               too many functions - The interpreter ran out of 
                    Function Table space.  Try specifying a larger -F 
                    value when starting up SCI.  

               too many variables                                
               too many variables - The interpreter ran out of 
                    Variable Table space.  Try specifying a larger -V 
                    value when starting up SCI.  

               out of memory                                        
               out of memory - The interpreter ran out of Program 
                    space.  Try specifying a larger -P value when 
                    starting up SCI.  

               stmt outside of function                              
               stmt outside of function - There is something wrong 
                    with the structure of your program.  Typically 
                    this results from a statement appearing outside of 
                    any function body.  

               missing                                                   
               missing '{' - The left brace that introduces a function 
                    body was missing.  

               wrong   of arguments in sys call                   
               wrong # of arguments in sys call - The number of 
                    arguments passed to a "sys" call is incorrect for 
                    the specified "sys" number.  

               undefined variable                                      
               undefined variable - A variable has been used without 
                    ever having been declared.  

               variable already declared                            
               variable already declared - An attempt was made to 
                    re-declare a variable name within the program or 
                    function.  

               interrupt                                                 
               interrupt - The program was interrupted by pressing the 
                    <ESCAPE> key.  



















          APPENDIX                   - 52 -

