(*

        UNIT Portfolio, Version 2.0

        This unit allows access to the Portfolio's special features.
        It also serves as a partial replacement for Turbo Pascal's CRT
        unit.  Some features are implemented only to allow for easier
        translation of Pascal program to the Portfolio, but have no effect.
        A more complete implementation of the CRT unit is planned.

        Written by BJ Gleason

        Copyright (c) 1991, BJ Gleason

        This source file contains confidential Information.
        This source file may only be used by Registered Atari Portfolo
        Developers.  The resulting UNIT may be used freely in any
        program.  You are not permitted to distribute the UNIT itself.

        BJ Gleason
        The American University
        Computer Science and Information Systems
        4400 Massachusetts Avenue, N.W.
        Washinton, D.C.  20016

*)

unit portfolio;
interface

uses dos;

const
     BW40 = 0;
     BW80 = 2;
     MONO = 7;
     CO40 = 1;
     CO80 = 3;
     C40  = CO40;
     C80  = CO80;

     BLACK         = 0;
     BLUE          = 1;
     GREEN         = 2;
     CYAN          = 3;
     RED           = 4;
     MAGENTA       = 5;
     BROWN         = 6;
     LIGHTGRAY     = 7;
     DARKGRAY      = 8;
     LIGHTBLUE     = 9;
     LIGHTGREEN    = 10;
     LIGHTCYAN     = 11;
     LIGHTRED      = 12;
     LIGHTMANGENTA = 13;
     YELLOW        = 14;
     WHITE         = 15;
     BLINK         = 128;

var

   lastmode : word;
   textattr : byte;
   windmax, windmin : word;
   directvideo : boolean;
   checksnow : boolean;


PROCEDURE PortDial(Number : String);
PROCEDURE PortOff;
PROCEDURE PortRefresh;
PROCEDURE PortBox(X1,Y1,X2,Y2,Border : Integer);
PROCEDURE PortErrorWindow(X,Y:Integer; Message : String);
PROCEDURE PortMessageWindow(X,Y : Integer; Title, Message : String);
FUNCTION  PortMenu(X, Y, Border, Depth, TopLine, SelectLine : Integer;
                    Title, MenuText, DefaultText : String) : Integer;
PROCEDURE PortKeyClick;
PROCEDURE PortBeep;
PROCEDURE PortAlarm;
PROCEDURE PortSound(Tone, Length : Integer);
PROCEDURE PortStatusLine(X,Y,OnOff : Integer);
PROCEDURE PortSetTickSpeed(Speed : Integer);
FUNCTION  PortGetTickSpeed : Integer;
PROCEDURE PortSetDisplayMode(Mode : Integer);
FUNCTION  PortGetDisplayMode : Integer;
PROCEDURE PortSetVirtualScreenLocation(X,Y : Integer);
PROCEDURE PortMoveVirtualScreen(Direction, Distance : Integer);

PROCEDURE PortInitialization;
FUNCTION  PortGetSizeInternalDisk : Integer;
FUNCTION  PortGetPhysicalScreenRows : Integer;
FUNCTION  PortGetLogicalScreenRows : Integer;
FUNCTION  PortGetPhysicalScreenCols : Integer;
FUNCTION  PortGetLogicalScreenCols : Integer;
FUNCTION  PortGetCursorMode : Integer;
PROCEDURE PortSetCursorMode (Mode : Integer);
FUNCTION  PortGetVirtualScreenX : Integer;
FUNCTION  PortGetVirtualScreenY : Integer;
FUNCTION  PortGetKeyboardLanguage : Integer;
FUNCTION  PortGetTextLanguage : Integer;
PROCEDURE PortSetKeyboardLanguage(Language : Integer);
PROCEDURE PortSetTextLanguage(Language : Integer);
FUNCTION  PortRomVersion : Real;
FUNCTION  IsPort : Boolean;
FUNCTION  PortBoxAreaCalculation(var X,Y : Integer;
                    Title, MenuText, DefaultText : String) : Integer;
PROCEDURE PortScreenSaveAndRestore(X1, Y1, X2, Y2, Command : Integer;
                    var Buffer : String);

{replacements for CRT unit}
FUNCTION  KeyPressed : Boolean;
FUNCTION  ReadKey : Char;
FUNCTION  WhereX : Integer;
FUNCTION  WhereY : Integer;
PROCEDURE ClrScr;
PROCEDURE GotoXY(X,Y : Integer);
PROCEDURE HighVideo;
PROCEDURE LowVideo;
PROCEDURE NormVideo;
PROCEDURE TextBackground(color:byte);
PROCEDURE TextColor(color:byte);
PROCEDURE TextMode(Mode:Integer);

implementation

var lastkey, fkey :char;


PROCEDURE PortDial(Number : String);
  var regs:registers;
  Begin
    number := number + Chr(0);
    regs.ah := $17;
    regs.si := ofs(number)+1;
    regs.ds := seg(number);
    regs.cX := length(number);
    intr($61,regs);
  End;

PROCEDURE PortOff;
  var regs:registers;
  Begin
    regs.ah := $2d;
    intr($61,regs);
  End;

PROCEDURE PortBox(X1,Y1,X2,Y2,Border : Integer);
  var regs:registers;
  Begin
    regs.dh := y1-1;
    regs.dl := x1-1;
    regs.ch := y2-1;
    regs.cl := x2-1;
    regs.al := Border;
    regs.ah := $09;
    regs.bh := 0;
    intr($60,regs);
  End;

PROCEDURE PortErrorWindow(X,Y:Integer; Message : String);
  var regs:registers;
  Begin
    Message := Message + Chr(0) + Chr(0);
    regs.dh := y-1;
    regs.dl := x-1;
    regs.ah := $14;
    regs.bh := 0;
    regs.si := ofs(Message)+1;
    regs.ds := seg(Message);
    regs.cX := length(Message)-1;
    intr($60,regs);
  End;

FUNCTION PortMenu(X, Y, Border, Depth, TopLine, SelectLine : Integer;
                   Title, MenuText, DefaultText : String) : Integer;
  var regs:registers;
  Begin

     menutext := title + Chr(0) + menuText + Chr(0) + Chr(0);
     defaulttext := defaultText + Chr(0) + Chr(0);
     regs.ah := $0f;
     regs.al := Border; {+depth * 8}
     regs.bh := 0;
     regs.ch := topLine;
     regs.cl := selectLine;
     regs.dh := y-1;
     regs.dl := x-1;
     regs.ds := seg(menutext);
     regs.si := ofs(menutext)+1;
     regs.es := seg(defaulttext);
     regs.di := ofs(defaulttext)+1;
     intr($60, regs);
     PortMenu := regs.ax;
  End;


PROCEDURE PortMessageWindow(X,Y : Integer; Title, Message:String);
  var regs:registers;
  Begin
     Message := title + Chr(0) + Message + Chr(0) + Chr(0);
     regs.ah := $12;
     regs.bh := 0;
     regs.dh := y-1;
     regs.dl := x-1;
     regs.ds := seg(Message);
     regs.si := ofs(Message)+1;
     intr($60, regs);
  End;

PROCEDURE PortRefresh;
  var regs:registers;
  Begin
    regs.ah := $12;
    intr($61, regs);
  End;

PROCEDURE PortNoise(snd : Integer);
  var regs:registers;
  Begin
    regs.ah := $15;
    regs.al := snd;
    intr($61, regs);
  End;

PROCEDURE PortKeyClick;
  Begin
    PortNoise(0);
  end;

PROCEDURE PortBeep;
  Begin
    PortNoise(1);
  end;

PROCEDURE PortAlarm;
  var c : char;
  Begin
    PortNoise(2);
    {if you press a key to abort the alarm, it is left in the buffer}
    {This clears the keyboard buffer....}
    memw[$40:$1c]:=memw[$40:$1a]
  end;

PROCEDURE PortSound(Tone, Length : Integer);
  var regs:registers;
  Begin
    regs.dl := Tone;
    regs.cX := Length;
    regs.ah := $16;
    intr($61, regs);
  End;

PROCEDURE PortStatusLine(X,Y,onoff : Integer);
  var regs:registers;
  Begin
    regs.dh := y-1;
    regs.dl := x-1;
    regs.ah := $2e;
    regs.al := onoff;
    intr($61, regs);
  End;

PROCEDURE PortSetTickSpeed(speed:Integer);
  var regs:registers;
  Begin
    regs.ax := $1e01;
    regs.bx := speed;
    intr($61, regs);
  End;

FUNCTION  PortGetTickSpeed : Integer;
  var regs:registers;
  Begin
    regs.ax := $1e00;
    intr($61, regs);
    PortGetTickSpeed := regs.bx;
  End;


PROCEDURE PortSetDisplayMode(Mode : Integer);
  var regs:registers;
  Begin
    regs.dl := Mode;
    regs.ax := $0e01;
    intr($61, regs);
  End;

FUNCTION  PortGetDisplayMode : Integer;
  var regs:registers;
  Begin
    regs.ax := $0e00;
    intr($61, regs);
    PortGetDisplayMode := regs.dl;
  End;

PROCEDURE PortSetVirtualScreenLocation(X,Y : Integer);
  var regs:registers;
  Begin
    regs.dh := y-1;
    regs.dl := x-1;
    regs.ax := $1001;
    intr($61, regs);
  End;

PROCEDURE PortMoveVirtualScreen(direction, distance : Integer);
  var regs:registers;
  Begin
    regs.dl := direction;
    regs.al := distance;
    regs.ah := $11;
    intr($61, regs);
  End;

PROCEDURE PortInitialization;
  var regs:registers;
  Begin
    regs.ah := 0;
    intr($61, regs);
  End;

FUNCTION  PortGetSizeInternalDisk : Integer;
  var regs:registers;
  Begin
    regs.ah := 8;
    intr($61, regs);
    PortGetSizeInternalDisk := regs.bx;
  End;

FUNCTION  PortGetPhysicalScreenRows : Integer;
  var regs:registers;
  Begin
    regs.ah := $0d;
    intr($61, regs);
    PortGetPhysicalScreenRows := regs.ah
  End;

FUNCTION  PortGetLogicalScreenRows : Integer;
  var regs:registers;
  Begin
    regs.ah := $0d;
    intr($61, regs);
    PortGetLogicalScreenRows := regs.dh;
  End;

FUNCTION  PortGetPhysicalScreenCols : Integer;
  var regs:registers;
  Begin
    regs.ah := $0d;
    intr($61, regs);
    PortGetPhysicalScreenCols := regs.al;
  End;

FUNCTION  PortGetLogicalScreenCols : Integer;
  var regs:registers;
  Begin
    regs.ah := $0d;
    intr($61, regs);
    PortGetLogicalScreenCols := regs.dl;
  End;

FUNCTION  PortGetCursorMode : Integer;
  var regs:registers;
  Begin
    regs.ax := $0f00;
    intr($61, regs);
    PortGetCursorMode := regs.bl;
  End;

PROCEDURE PortSetCursorMode(Mode : Integer);
  var regs:registers;
  Begin
    regs.ax := $0f01;
    if Mode=3 then regs.al := 2;
    regs.bl := Mode;
    intr($61, regs);
  End;


FUNCTION  PortGetVirtualScreenX : Integer;
  var regs:registers;
  Begin
    regs.ax := $1000;
    intr($61, regs);
    PortGetVirtualScreenX := regs.dl+1;
  End;

FUNCTION  PortGetVirtualScreenY : Integer;
  var regs:registers;
  Begin
    regs.ax := $1000;
    intr($61, regs);
    PortGetVirtualScreenY := regs.dh+1;
  End;

FUNCTION  PortGetKeyboardLanguage : Integer;
  var regs:registers;
  Begin
    regs.ax := $2800;
    intr($61, regs);
    PortGetKeyboardLanguage := regs.dl;
  End;


FUNCTION  PortGetTextLanguage : Integer;
  var regs:registers;
  Begin
    regs.ax := $2800;
    intr($61, regs);
    PortGetTextLanguage := regs.dh;
  End;


PROCEDURE PortSetKeyboardLanguage(language : Integer);
  var regs:registers;
  Begin
    regs.ax := $2801;
    regs.dl := language;
    regs.dh := $80;
    intr($61, regs);
  End;


PROCEDURE PortSetTextLanguage(language : Integer);
  var regs:registers;
  Begin
    regs.ax := $2801;
    regs.dl := $80;
    regs.dh := language;
    intr($61, regs);
  End;

FUNCTION  PortRomVersion : Real;
  var regs:registers;
      ver : string;
      x : Integer;
      n : real;

  begin
    ver := ' ';
    regs.ah := 0;
    intr($60, regs);

    repeat
      ver := ver + chr(mem[regs.ds:regs.dx]);
      inc(regs.dx);
    until mem[regs.ds:regs.dx]=0;
    val(ver, n, x);
    PortRomVersion := n;
  end;

(*

  This function will check the memory location for the string 'DI'
  to determine if the machine is a Portfolio.  This will return
  false in running on a PC.  If you want to use this function of a
  PC and you have loaded I60 and I61, then remove the comments around
  the last line...    Besure to comment this back out when you go to
  production.

*)

FUNCTION  IsPort:Boolean;
  begin
    if (memw[$F000:$FFEA]=$4944) then IsPort:=True
                                 else IsPort:=False;
    (* IsPort := True; *)
  end;

FUNCTION  PortBoxAreaCalculation(var X,Y : Integer; Title, MenuText,
                                     DefaultText : String) : Integer;
  var regs:registers;
  begin
     menuText := title + Chr(0) + menuText + Chr(0) + Chr(0);
     defaultText := defaultText + Chr(0) + Chr(0);
    regs.ah := $10;
    regs.dh := y-1;
    regs.dl := x-1;
    regs.ds := seg(MenuText);
    regs.si := ofs(MenuText)+1;
    regs.es := seg(DefaultText);
    regs.di := ofs(DefaultText)+1;
    intr($60, regs);
    x := regs.cl+1;
    y := regs.ch+1;
    PortBoxAreaCalculation := regs.bx;
  end;

PROCEDURE PortScreenSaveAndRestore(X1, Y1, X2, Y2, Command : Integer;
                                                   var Buffer : String);
  var regs:registers;
  begin
    regs.ah := $08;
    regs.al := Command;
    regs.bh := 0;
    regs.ch := y2-1;
    regs.cl := x2-1;
    regs.dh := y1-1;
    regs.dl := x1-1;
    regs.ds := seg(buffer);
    regs.si := ofs(buffer)+1;
    intr($60, regs);
  end;

PROCEDURE ClrScr;
  var regs:registers;
  begin
    regs.ah := $0F;
    intr($10,regs);
    regs.ah := $0;
    intr($10,regs);
  end;

PROCEDURE GotoXY(x,y:integer);
  var regs:registers;
  begin
    regs.ah := 2;
    regs.bh := 0;
    regs.dh := y-1;
    regs.dl := x-1;
    intr($10, regs);
  end;

FUNCTION  KeyPressed : Boolean;
  var regs:registers;
  begin
    regs.ah := 1;
    intr($16, regs);
    if ((64 and Regs.Flags) <> 0) then keypressed:= false
     else keypressed:=true;
  end;

FUNCTION  ReadKey : Char;
  var regs:registers;
  begin
    if lastkey=#0 then
      begin
        lastkey:=' ';
        Readkey:=fkey;
      end
     else
      begin
       regs.ah := 0;
       intr($16, regs);
       lastkey:=chr(regs.al);
       fkey:=chr(regs.ah);
       ReadKey := chr(regs.al);
      end;
  end;

FUNCTION  WhereX;
  var regs:registers;
  begin
    regs.ah := 3;
    regs.bh := 0;
    intr($10, regs);
    WhereX := regs.dl+1;
  end;

FUNCTION  WhereY;
  var regs:registers;
  begin
    regs.ah := 3;
    regs.bh := 0;
    intr($10, regs);
    WhereY := regs.dh+1;
  end;

PROCEDURE HighVideo;
  begin
       TextAttr := TextAttr or $08;
  end;

PROCEDURE LowVideo;
  begin
       TextAttr := TextAttr and $F7;
  end;

PROCEDURE NormVideo;
  begin
       TextAttr := WHITE;
  end;

PROCEDURE TextBackground(color:byte);
  begin
       TextAttr := TextAttr and ((color * 16) and $70);
  end;

PROCEDURE TextColor(color:byte);
  begin
       TextAttr := TextAttr and (color and $0f);
       if color > 15 then TextAttr := TextAttr or $80
                     else TextAttr := TextAttr and $7F;
  end;

PROCEDURE TextMode(Mode:integer);
  var regs:registers;
  begin
    regs.ah := $0f;
    intr($10, regs);
    lastmode := regs.al;
    regs.ah :=0;
    regs.al := mode;
    intr($10, regs);
  end;

var regs:registers;

Begin
 lastkey:=' ';
 fkey:=' ';
 directvideo := false;
 checksnow := false;
 textattr := WHITE;
 regs.ah := $0f;
 intr($10, regs);
 lastmode := regs.al;
End.

