(* ----------------------------------------------------------------------- *)
(* Pascal Unit : PortHelp                                                  *)
(*          - In dieser Unit werden alle weiteren hilfreichen Funktionen   *)
(*            des Portfolio eingebaut.                                     *)
(*          - Die Funktionen benutzen den Interrupt $61.                   *)
(* letzte nderung : 10. April 1996                                        *)
(* ----------------------------------------------------------------------- *)
Unit PortHelp;

Interface

     (* Es wird der aktuelle Modus des Cursors zurckgeliefert. Mgliche *)
     (* Werte sind : 0 - Cursor ausschalten                              *)
     (*              1 - Cursor als Unterstrich                          *)
     (*              2 - Cursor als Block                                *)
     Function  GetCursorMode : Byte;

     (* Setzt den Cursormodus. Werte fr mode wie in GetCursorMode *)
     Function  SetCursorMode ( mode : Byte ) : Byte;

     (* Aktiviert die System-Status-Leiste (Urzeit/Datum/Keyboardstate) *)
     (* Zeile wird ab xPos und yPos dargestellet                        *)
     Procedure EnableSystemStatusLine ( xPos, yPos : Byte );

     (* Lscht dei System-Status-Leiste wieder vom Bildschirm *)
     Procedure DisableSystemStatusLine;

     (* Lst einen von drei verschiedenen Tnen aus : *)
     (*            0 = Key-click                      *)
     (*            1 = Beep                           *)
     (*            2 = Alarm                          *)
     Procedure SoundGeneration ( soundType : Byte );

     (* Spielt einen Tone dessen Lnge und Tonehhe verndert werden *)
     (* kann. soundLength ist die dauer des Tons in 10ms. Folgende   *)
     (* Werte gelten fr die toneCodes :                             *)
     (*      48      30h     D#5     622.3 Hz                        *)
     (*      49      31h     E-5     659.3 Hz                        *)
     (*      50      32h     F-5     698.5 Hz                        *)
     (*      51      33h     F#5     740.0 Hz                        *)
     (*      52      34h     G-5     784.0 Hz                        *)
     (*      53      35h     G#5     830.6 Hz                        *)
     (*      54      36h     A-5     880.6 Hz                        *)
     (*      55      37h     A#5     932.3 Hz                        *)
     (*      56      38h     B-5     987.8 Hz                        *)
     (*      57      39h     C-6     1046.5 Hz                       *)
     (*      58      3Ah     C#6     1108.7 Hz                       *)
     (*      47      29h     D-6     1174.7 Hz                       *)
     (*      59      3Bh     D#6     1244.5 Hz                       *)
     (*      60      3Ch     E-6     1318.5 Hz                       *)
     (*      61      3Dh     F-6     1396.9 Hz                       *)
     (*      14      0Eh     F#6     1480.0 Hz                       *)
     (*      62      3Eh     G-6     1568.9 Hz                       *)
     (*      44      2Ch     G#6     1661.2 Hz                       *)
     (*      63      3Fh     A-6     1760.0 Hz                       *)
     (*       4      04h     A#6     1864.7 Hz                       *)
     (*       5      05h     B-6     1975.5 Hz                       *)
     (*      37      25h     C-7     2093.0 Hz                       *)
     (*      47      2Fh     C#7     2217.5 Hz                       *)
     (*       6      06h     D-7     2349.3 Hz                       *)
     (*       7      07h     D#7     2489.0 Hz                       *)
     Procedure MelodyTone ( soundLength : Word; toneCode : Byte );

Implementation

Uses Dos, PortCRT;

Function GetCursorMode : Byte;
    Var reg : Registers;
Begin
     reg.ah := $0F;
     reg.al := 0;
     Intr ( $61, reg );
     GetCursorMode := reg.bl;
End;

Function SetCursorMode ( mode : Byte ) : Byte;
    Var reg : Registers;
Begin
     reg.ah := $0F;
     reg.al := 1;
     reg.bl := mode;
     Intr ( $61, reg );
     SetCursorMode := reg.bl;
End;

Procedure EnableSystemStatusLine ( xPos, yPos : Byte );
    Var reg : Registers;
Begin
     reg.ah := $2E;
     reg.al := 1;
     reg.dl := xPos;
     reg.dh := yPos;
     Intr ( $61, reg );
End;

Procedure DisableSystemStatusLine;
    Var reg : Registers;
Begin
     reg.ah := $2E;
     reg.al := 0;
     Intr ( $61, reg );
End;

Procedure SoundGeneration ( soundType : Byte );
    Var reg : Registers;
Begin
     reg.ah := $15;
     reg.al := soundType;
     Intr ( $61, reg );
End;

Procedure MelodyTone ( soundLength : Word; toneCode : Byte );
    Var reg : Registers;
Begin
     reg.ah := $16;
     reg.cx := soundLength;
     reg.dl := toneCode;
     Intr ( $61, reg );
End;

Begin
End.