(* ----------------------------------------------------------------------- *)
(* Pascal Unit : PortCRT                                                   *)
(*          - Die Unit soll die orginal CRT-Unit von Pascal ersetzen.      *)
(*          - Die Funktionen dieser Unit sind aufrufkompatiebel zur        *)
(*            normalen Unit.                                               *)
(* letzte nderung : 10. April 1996                                        *)
(* ----------------------------------------------------------------------- *)
Unit PortCRT;

Interface

(* Konstanten fr die Textmode Prozedur *)
Const portfolio = 1;
      statisch  = 0;
      dynamisch = 2;

     Procedure Textmode ( mode : Byte );

	 Procedure ClrScr;

	 Procedure GotoXY ( column, row : Byte );
	
	 Function  WhereX : Byte;
	
	 Function  WhereY : Byte;
	
	 Function  KeyPressed : Boolean;
	
	 Function  ReadKey : Char;
	
Implementation

Uses Dos;

Var reg : Registers;
    CharBuffer : Byte;
	ScreenMode : Byte;

Procedure Textmode ( mode : Byte );
	Var reg : Registers;
Begin
     If ( ( mode >= 0 ) And ( mode <= 2 ) ) Then
	 Begin
          reg.ah := $0E;
  		  reg.al := 1;
  		  reg.dl := mode;
  		  Intr ( $61, reg );
  		  ScreenMode := mode;
     End;
End;

Procedure ClrScr;
	Var reg: Registers;
Begin
     reg.ah := $06;
     reg.al := 0;
     reg.bh := 7;
     reg.cl := 0;
     reg.ch := 0;
     reg.dl := 39;
     reg.dh := 7;
     Intr ( $10, reg );
End;

Procedure GotoXY ( column, row : Byte );
	Var reg : Registers;
Begin
     reg.ah := $02;
     reg.bh := 0;
     reg.dl := column;
     reg.dh := row;
     Intr ( $10, reg );
End;

Function WhereX : Byte;
	Var reg : Registers;
Begin
     reg.ah := $03;
     reg.bh := 0;
     Intr ( $10, reg );
     WhereX := reg.dl;
End;

Function WhereY : Byte;
	Var reg : Registers;
Begin
     reg.ah := $03;
     reg.bh := 0;
     Intr ( $10, reg );
     WhereY := reg.dh;
End;

Function KeyPressed : Boolean;
	Var reg : Registers;
Begin
     reg.ah := $01;
  	 Intr ( $16, reg );
  	 If ( reg.flags And 64 ) <> 0 Then
        KeyPressed := False
  	 Else
    	KeyPressed := True;
End;

Function ReadKey : Char;
	Var reg : Registers;
Begin
     If CharBuffer = 0 Then
  	 Begin
          Repeat
      		    reg.ah := $01;
      		    Intr ( $16, reg );
    	  Until ( reg.flags And 64 ) = 0;
    	  reg.ah := $00;
    	  Intr ( $16, reg );
    	  ReadKey := Chr ( reg.al );
    	  If reg.al = 0 Then
      	     CharBuffer := reg.ah;
  	 End
  	 Else
  	 Begin
    	  ReadKey := Chr ( CharBuffer );
    	  CharBuffer := 0;
  	 End;
End;

(* -------------- Beginn der Initialisierungsroutine --------------------- *)
(*  nach dem Start befindet sich der Portfolio im 40x8 Zeichen Modus       *)
Begin
     CharBuffer := 0;
     reg.ah := $00;
     Intr ( $61, reg );
     Textmode ( portfolio );
End.