{ ------------------------------------------------------------------------- }
{ Pascal Unit : PortAES                                                     }
{          - Diese Unit stellt die Funktionen des Portfolio-AES zur         }
{            verfgung.                                                     }
{          - Alle Funktionen sind ber den Interrupt $60 zu ereichen.       }
{ letzte nderung : 19. Mai 1996                                            }
{ ------------------------------------------------------------------------- }
Unit PortAES;

Interface

Type ScreenbufferType = Array [ 1 .. 320 ] Of Byte; {}

Type EditorControlStructure = Record
                                  ep_targ : Pointer;  {}
                                  ep_pos  : Word;     {}
                                  ep_max  : Word;     {}
                                  ep_xpos : Byte;     {}
                                  ep_ypos : Byte;     {}
                                  ep_mode : Byte;     {}
                                  ep_hit  : Word;     {}
                                  ep_tit  : Pointer;  {}
                                  ep_exit : Pointer;  {}
                                  ep_fn   : Pointer;  {}
                                  ep_wid  : Byte;     {}
                                  ep_wind : Byte;     {}
                                  ep_res  : Longint;  {}
                                  ep_udel : Pointer;  {}
                              End;

     {}
     Function  LineEditor ( xtl, ytl, startMode, boxType : Byte;
                            maxLength : Word;
                            EditorTitle, EditorPrompt : String;
                            Var buffer : String ) : Boolean;

     {}
     Procedure SaveScreen ( xtl, ytl, xbr, ybr : Byte;
                            Var buffer : ScreenbufferType );

     {}
     Procedure RestoreScreen ( xtl, ytl, xbr, ybr : Byte;
                               buffer : ScreenbufferType );

     {}
     Procedure DrawBox ( xtl, ytl, xbr, ybr, lineType : Byte );

     {}
     Function  Menu ( xtl, ytl : Byte;
                      MenuTitle, MenuText, DefaultsText : String;
                      Var selectedItem : Byte ) : Boolean;

     {}
     Procedure BoxAreaCalculation ( xtl, ytl : Byte;
                                    TitleText, MenuText, DefaultsText : String;
                                    Var xbr, ybr : Byte );

     {}
     Procedure MessageWindow ( xtl, ytl : Byte;
                               WindowTitle, MessageText : String );

     {}
     Procedure ErrorWindow ( xtl, ytl : Byte;
                             ErrorText : String );

Implementation

Uses Dos;

{$I edithelp.inc }

Function LineEditor;

{ Taste zum verlassen des Editors : ESC und Return }
Const ExitCodes : Array [ 1 .. 3 ] Of Word = ( $001B, $000D, $0000 );

Var ecs : EditorControlStructure;
    reg : Registers;
    returnChar, zaehler : Word;
    startPos, width : Byte;

Begin
     { --- Datebn aufbereiten --------------------------------------------- }
     { nullterminierte Strings erzeugen }
     buffer := buffer + #0;
     EditorTitle := EditorTitle + #0 + ' ' + EditorPrompt + #0 + #0;
     { Cursorposition setzen }
     If buffer = '' Then
         startPos := 0
     Else
         startPos := Length( buffer ) - 1;
     { Dimension des Fensters festlegen }
     If ( maxLength + Length( EditorPrompt ) ) > 36 Then
         width := 40 - xtl
     Else
         width := maxLength + Length( EditorPrompt ) + 4 - xtl;
     { -------------------------------------------------------------------- }

     { --- Werte in der Kontrollstruktur setzen --------------------------- }
     ecs.ep_targ := Addr( buffer[ 1 ] );      { Adresse des Zeichenpuffers }
     ecs.ep_pos  := startPos;                 { Position des Cursors ist des Textende }
     ecs.ep_max  := maxLength;                { maximale Lnge des editierten Strings }
     ecs.ep_xpos := xtl;                      { X-Koordinate des Fensters }
     ecs.ep_ypos := ytl;                      { Y-Koordinate des Fensters }
     ecs.ep_mode := startMode;                { Startmodus 0 oder 2 }

     ecs.ep_hit  := 0;                        {  }

     ecs.ep_tit  := Addr( EditorTitle[ 1 ] ); { Titel und Prompt zusammen }
     ecs.ep_exit := Addr( ExitCodes[ 1 ] );   { als Konstante oben deklariert }
     ecs.ep_fn   := Addr( getkey );           { immer so}
     ecs.ep_wid  := width;                    { wird oben berechnet }
     ecs.ep_wind := boxType;                  { double line box }
     ecs.ep_res  := 0;                        { immer so }
     ecs.ep_udel := Addr( undel );            { immer so }
     { -------------------------------------------------------------------- }

     { --- Funktionsaufruf ------------------------------------------------ }
     reg.ah := 1;
     reg.ds := Seg( ecs );
     reg.si := Ofs( ecs );
     Intr( $60, reg );
     { -------------------------------------------------------------------- }
     

     { --- Zeichen mit dem die Ausgabe beendet wurde ---------------------- }
     returnChar := reg.ax;
     LineEditor := True;         { die Funktion liefert TRUE zurck ... }
     If returnChar = $001B Then  { oder FALSE wenn der Editor mit ESC beendet wurde }
        LineEditor := False;
     { -------------------------------------------------------------------- }
     
     { --- Lnge des Strings auf die Lnge des Rckgabestrings setzen ----- }
     buffer[ 0 ] := #0;               { Stringlnge auf Null setzen }
     zaehler := 1;                    { Zeichenzhler auf Eins setzen }
     While buffer[ zaehler ] <> #0 Do { so lange kein Nullzeichen auftaucht }
     Begin
          Inc( buffer[ 0 ] );         { Stringlnge um eins erhhen }
          Inc( zaehler );             { zaehler um eins erhhen }
     End;
End;

Procedure SaveScreen;
    Var reg : Registers;
Begin
     FillChar ( buffer, 320, 0 );
     reg.ah := $08;            { Funktionsnummer }
     reg.al := 0;              { Subservice Save Characters only }
     reg.bh := 0;              { Videopage number }
     reg.dl := xtl;            { X- und Y-Position der linken-oberen Ecke }
     reg.dh := ytl;
     reg.cl := xbr;            { X- und Y-Position der rechten-unteren Ecke }
     reg.ch := ybr;
     reg.ds := Seg ( buffer ); { Adrresse des Speicherbereichs in den }
     reg.si := Ofs ( buffer ); { gesichert werden soll                }
     Intr ( $60, reg );
End;

Procedure RestoreScreen;
    Var reg : Registers;
Begin
     reg.ah := $08;  { Funktionsnummer }
     reg.al := 2;    { Subservice Restore characters only }
     reg.bh := 0;    { Allers andere ist wie bei SaveScreen }
     reg.dl := xtl;
     reg.dh := ytl;
     reg.cl := xbr;
     reg.ch := ybr;
     reg.ds := Seg ( buffer );
     reg.si := Ofs ( buffer );
     Intr ( $60, reg );
End;

Procedure DrawBox;
    Var reg : Registers;
Begin
     reg.ah := $09;      { Funktionsnummer }
     reg.al := lineType; { 1 = double line; 0 = single line }
     reg.bh := 0;
     reg.dl := xtl;
     reg.dh := ytl;
     reg.cl := xbr;
     reg.ch := ybr;
     Intr ( $60, reg );
End;

Function Menu;
    Var reg : Registers;
Begin
     Menu := False;
     selectedItem := 0;
     MenuTitle := MenuTitle + Chr ( 0 );
     MenuText := MenuTitle + MenuText + Chr ( 0 ) + Chr ( 0 );
     DefaultsText := DefaultsText + Chr ( 0 ) + Chr ( 0 );
     reg.ah := $0F; { Funktionsnummer }
     reg.al := 1;   { 1 = double line; 0 = single line }
     reg.bh := 0;   { Video page number }
     reg.ch := 0;   { Last top line }
     reg.cl := 0;   { Menpunktnummer an der der Cursor stehen soll }
     reg.dl := xtl; { linke-obere Ecke des Mens }
     reg.dh := ytl;
     reg.ds := Seg ( MenuText );
     reg.si := Ofs ( MenuText ) + 1;
     reg.es := Seg ( DefaultsText );
     reg.di := Ofs ( DefaultsText ) + 1;
     Intr ( $60, reg );
     { Wenn AL = 255 ist, wurde das Men abgebrochen }
     If reg.al <> 255 Then
     Begin
          selectedItem := reg.al;
          Menu := True;
     End;
End;

Procedure BoxAreaCalculation;
    Var reg : Registers;
Begin
     TitleText := TitleText + Chr ( 0 );
     MenuText := TitleText + MenuText + Chr ( 0 ) + Chr ( 0 );
     DefaultsText := DefaultsText + Chr ( 0 ) + Chr ( 0 );
     reg.ah := $10;
     reg.dl := xtl;
     reg.dh := ytl;
     reg.ds := Seg ( MenuText );
     reg.si := Ofs ( MenuText ) + 1;
     reg.es := Seg ( DefaultsText );
     reg.di := Ofs ( DefaultsText ) + 1;
     Intr ( $60, reg );
     xbr := reg.cl;
     ybr := reg.ch;

     { Rckgabewerte : AH - Anzahl der Menpunkte plus Titelzeile        }
     {                 BX - Anzahl der Bytes, die gesichert werden men }
     {                 CX - rechte-untere Ecke des Mens                 }
     { 1 = double line; 0 = single line }
End;

Procedure MessageWindow;
    Var reg : Registers;
Begin
     WindowTitle := WindowTitle + Chr ( 0 );
     MessageText := MessageText + Chr ( 0 ) + Chr ( 0 );
     MessageText := WindowTitle + MessageText;
     reg.ah := $12;
     reg.dl := xtl;
     reg.dh := ytl;
     reg.ds := Seg ( MessageText );
     reg.si := Ofs ( MessageText ) + 1;
     Intr ( $60, reg );
End;

Procedure ErrorWindow;
    Var reg : Registers;
Begin
     ErrorText := ErrorText + Chr ( 0 ) + Chr ( 0 );
     reg.ah := $14;
     reg.bh := 0;
     reg.dl := xtl;
     reg.dh := ytl;
     reg.cx := 1;  { Dieser Wert mu immer <> Null sein }
     reg.ds := Seg ( ErrorText );
     reg.si := Ofs ( ErrorText ) + 1;
     Intr ( $60, reg );
End;

Begin
End.