/*****************************************************************
	Header file for PGLIB.LIB - The Atari Porfolio Graphics Library
	(c)Copyright 1991 Software Vineyard  All Rights Reserved.
	See PGCLIB.DOC for licensing terms
******************************************************************/

/*	Color Definitions for PG_Plot and PG_GetPixel */
#define	WHITE		0
#define	BLACK		1

/* Return codes from PG_Show, PG_Read, and PG_Save */
#define	OK			0  	/* everything was OK */
#define	BADOPEN  1		/* error opening file */
#define	NOTPGC	2		/* not a PGC file */
#define	BADWRITE	3		/* error writing file - PG_Save */

/*	Dummy value to pass to PG_Read and PG_Move to use screen as source
	or destination	*/
#define	SCREEN	0L

/*	Function Prototypes */
int	PG_Init(void);
void	PG_GoGraphic(void);
void	PG_GoText(void);
void	PG_Refresh(void);
void	PG_ClearScreen(void);
void	PG_QPlot(int x, int y, int color);
void	PG_Plot(int x, int y, int color);
int	PG_GetPixel(int x, int y);
int 	PG_Show(char *filename);
int 	PG_Load(char *filename, char far *buffer);
void	PG_Move(char far *tobuffer, char far *frombuffer);
int	PG_Save(char *filename, char far *buffer);



