/* PGSAMPLE.C - Program to test PGLIB */
#include	<stdio.h>
#include	<dos.h>
#include	"pglib.h"

char	fuji[1920];
char	portf[1920];

main()
{
	int i, j, result;

	/* initialize the graphics routines */
	result = PG_Init();
	if(result == 0)
	{
		puts("This is not an Atari Portfolio!");
		exit(1);
	}

	/* put Portfolio into graphics mode */
	PG_GoGraphic();

	/* Plot some pixels */
	PlotSpiral();

	/* wait for a bit */
   for(j = 0; j < 30000; j++);

	/* draw some lines */
	PG_Line(0,0,239,63);
	PG_Line(0,63,239,0);

	/* wait for a bit */
   for(j = 0; j < 30000; j++);

	/* load in a picture */
	PG_Show("portf.pgc");
   PG_Move((char far *)portf, SCREEN);
	PG_Load("fuji.pgc", (char far *)fuji);

	/* wait for a bit */
	for(j = 0; j < 30000; j++);

	/* clear the screen */
	PG_ClearScreen();

	for(i = 0; i < 10; i++)
	{
		PG_Move(SCREEN, (char far *)fuji);
		PG_Move(SCREEN, (char far *)portf);
	}

	/* save screen to disk as PGC file */
	result = PG_Save("newportf.pgc", SCREEN);
	if(result != OK)
	{
		PG_GoText();
		if(result == BADOPEN) puts("Error opening file");
		else puts("Error writing file");
		exit(1);
	}

	/* save buffer to disk as PGC file */
	result = PG_Save("newfuji.pgc", (char far *)fuji);
	if(result != OK)
	{
		PG_GoText();
		if(result == BADOPEN) puts("Error opening file");
		else puts("Error writing file");
		exit(1);
	}

	/* return to text mode */
	PG_GoText();
}

PlotSpiral()
{
   int x, y;
   int x1 = 0;
   int x2 = 239;
   int y1 = 0;
   int y2 = 63;

	/* plot in quiet mode */
   while (y1 < 32)
   {
      for (x = x1; x <= x2; x++) PG_QPlot(x, y1, BLACK);
      for (y = y1; y <= y2; y++) PG_QPlot(x2, y, BLACK);
      for (x = x2; x >= x1; x--) PG_QPlot(x, y2, BLACK);
      for (y = y2; y >= y1; y--) PG_QPlot(x1, y, BLACK);
      x2 -= 2; y2 -= 2; y1 += 2; x1 += 2;
	}

	/* now show it */
	PG_Refresh();

	/* Plot in normal mode */
	while(y1 > 0)
   {
      x2 += 2; y2 += 2; y1 -= 2; x1 -= 2;
      for (x = x1; x <= x2; x++) PG_Plot(x, y1, WHITE);
      for (y = y1; y <= y2; y++) PG_Plot(x2, y, WHITE);
      for (x = x2; x >= x1; x--) PG_Plot(x, y2, WHITE);
      for (y = y2; y >= y1; y--) PG_Plot(x1, y, WHITE);
   }
}




