/**********************************************************************/
/***     DEMO-PROGRAMM fuer ATARI PORTFOLIO                         ***/
/***     Messwerterfassung mit UNICARD aus Elrad 4/91               ***/
/***     Mit Bargraph                                               ***/
/***     Erstellt mit Turbo C 2.0                                   ***/
/***     Von Felix Bertram am 09.12.91                              ***/
/**********************************************************************/
/***     Das Programm ist ohne Modifikation auf dem Portfolio       ***/
/***     sowie einem PC mit CGA-kompatibler Karte lauffaehig.       ***/
/**********************************************************************/
/***     Das Programm kann jederzeit durch einen Tastendruck        ***/
/***     abgebrochen werden.                                        ***/
/**********************************************************************/

#include <stdio.h>
#include <dos.h> /* Funktionen fuer Interrupt-Aufrufe */

#define         GRAFICS 0x05    /* CGA, 320x200  */
#define         TEXT    0x07    /* Textmodus     */

#define         WHITE   15      /* Pixel set/reset arbeitet */
#define         BLACK   0       /* mit diesen Farben        */

#define         PORTA   0x300   /* Adressen der UniCard */
#define         PORTB   PORTA+1
#define         PORTC   PORTA+2
#define         CTRL    PORTA+3
#define         ADC     PORTA+4

void    set_video(int mode);
void    pixel(int x,int y,int color);

void    init_card(void);
int     messen(int channel);

void    bar(int mess,int mess_alt,int channel);
void    val(int mess,int channel);

int     kbhit(void);
int     rand(void);

/*-------------------------------------------------------------------*/
/* Die folgenden Zeilen enthalten Routinen und Datenfelder           */
/* fuer gemischte Text- und Grafikdarstellung auf dem Portfolio      */

void    printg(char *string);
void    graph_c(int c);
void    go_rc(int row,int col);

int     _x,   /* Diese globalen Variablen     */
        _y;   /* enthalten die Cursorposition */

char    _chars[][7]=
        {  /* Dies ist die Zeichensatztabelle, 5x7-Matrix */
                {0x00,0x00,0x00,0x00,0x00,0x00,0x00},   /* Space */
                {0x04,0x04,0x04,0x04,0x00,0x00,0x04},   /* ! */
                {0x0a,0x0a,0x00,0x00,0x00,0x00,0x00},   /* " */
                {0x0a,0x0a,0x1f,0x0a,0x1f,0x0a,0x0a},   /* # */
                {0x04,0x0f,0x14,0x0e,0x05,0x1e,0x04},   /* $ */
                {0x18,0x19,0x02,0x04,0x08,0x13,0x03},   /* % */
                {0x08,0x14,0x14,0x08,0x15,0x12,0x0d},   /* & */
                {0x04,0x04,0x00,0x00,0x00,0x00,0x00},   /* ' */
                {0x02,0x04,0x08,0x08,0x08,0x04,0x02},   /* ( */
                {0x08,0x04,0x02,0x02,0x02,0x04,0x08},   /* ) */
                {0x00,0x04,0x15,0x0e,0x15,0x04,0x00},   /* * */
                {0x00,0x04,0x04,0x1f,0x04,0x04,0x00},   /* + */
                {0x00,0x00,0x00,0x00,0x00,0x0c,0x04},   /* , */
                {0x00,0x00,0x00,0x1f,0x00,0x00,0x00},   /* - */
                {0x00,0x00,0x00,0x00,0x00,0x00,0x04},   /* . */
                {0x00,0x01,0x02,0x04,0x08,0x10,0x00},   /* / */
                {0x0e,0x11,0x13,0x15,0x19,0x11,0x0e},   /* 0 */
                {0x04,0x0c,0x04,0x04,0x04,0x04,0x0e},   /* 1 */
                {0x0e,0x11,0x01,0x0e,0x10,0x10,0x1f},   /* 2 */
                {0x0e,0x11,0x01,0x06,0x01,0x11,0x0e},   /* 3 */
                {0x12,0x12,0x12,0x1f,0x02,0x02,0x02},   /* 4 */
                {0x1f,0x10,0x10,0x1e,0x01,0x11,0x0e},   /* 5 */
                {0x0e,0x10,0x10,0x1e,0x11,0x11,0x0e},   /* 6 */
                {0x1f,0x01,0x01,0x02,0x04,0x04,0x04},   /* 7 */
                {0x0e,0x11,0x11,0x0e,0x11,0x11,0x0e},   /* 8 */
                {0x0e,0x11,0x11,0x0f,0x01,0x11,0x0e},   /* 9 */
                {0x00,0x00,0x04,0x00,0x00,0x04,0x00},   /* : */
                {0x00,0x00,0x00,0x04,0x00,0x0c,0x04},   /* ; */
                {0x02,0x04,0x08,0x10,0x08,0x04,0x02},   /* < */
                {0x00,0x00,0x1f,0x00,0x1f,0x00,0x00},   /* = */
                {0x08,0x04,0x02,0x01,0x02,0x04,0x08},   /* > */
                {0x0e,0x11,0x01,0x06,0x04,0x00,0x04},   /* ? */
                {0x0e,0x11,0x17,0x17,0x17,0x10,0x0e},   /* @ */
                {0x04,0x0a,0x11,0x1f,0x11,0x11,0x11},   /* A */
                {0x1e,0x11,0x11,0x1e,0x11,0x11,0x1e},   /* B */
                {0x0e,0x11,0x10,0x10,0x10,0x11,0x0e},   /* C */
                {0x1e,0x11,0x11,0x11,0x11,0x11,0x1e},   /* D */
                {0x1f,0x10,0x10,0x1e,0x10,0x10,0x1f},   /* E */
                {0x1f,0x10,0x10,0x1e,0x10,0x10,0x10},   /* F */
                {0x0e,0x11,0x10,0x17,0x11,0x11,0x0e},   /* G */
                {0x11,0x11,0x11,0x1f,0x11,0x11,0x11},   /* H */
                {0x0e,0x04,0x04,0x04,0x04,0x04,0x0e},   /* I */
                {0x0e,0x04,0x04,0x04,0x04,0x14,0x0c},   /* J */
                {0x11,0x12,0x14,0x18,0x14,0x12,0x11},   /* K */
                {0x10,0x10,0x10,0x10,0x10,0x10,0x1f},   /* L */
                {0x11,0x1b,0x15,0x15,0x15,0x11,0x11},   /* M */
                {0x11,0x11,0x19,0x15,0x13,0x11,0x11},   /* N */
                {0x0e,0x11,0x11,0x11,0x11,0x11,0x0e},   /* O */
                {0x1e,0x11,0x11,0x1e,0x10,0x10,0x10},   /* P */
                {0x0e,0x11,0x11,0x11,0x15,0x12,0x0d},   /* Q */
                {0x1e,0x11,0x11,0x1e,0x11,0x11,0x11},   /* R */
                {0x0e,0x11,0x10,0x0e,0x01,0x11,0x0e},   /* S */
                {0x1f,0x04,0x04,0x04,0x04,0x04,0x04},   /* T */
                {0x11,0x11,0x11,0x11,0x11,0x11,0x0e},   /* U */
                {0x11,0x11,0x11,0x11,0x11,0x0a,0x04},   /* V */
                {0x11,0x11,0x11,0x15,0x15,0x15,0x0a},   /* W */
                {0x11,0x11,0x0a,0x04,0x0a,0x11,0x11},   /* X */
                {0x11,0x11,0x0a,0x04,0x04,0x04,0x04},   /* Y */
                {0x1f,0x01,0x02,0x04,0x08,0x10,0x1f},   /* Z */
                {0x0e,0x08,0x08,0x08,0x08,0x08,0x0e},   /* [ */
                {0x00,0x10,0x08,0x04,0x02,0x01,0x00},   /* \ */
                {0x0e,0x02,0x02,0x02,0x02,0x02,0x0e},   /* ] */
                {0x04,0x0a,0x00,0x00,0x00,0x00,0x00},   /* ^ */
                {0x00,0x00,0x00,0x00,0x00,0x00,0x1f},   /* _ */
                {0x04,0x06,0x00,0x00,0x00,0x00,0x00},   /* ` */
        };
void go_rc(int row,int col)
{/* Cursor fuer Textausgabe setzen */
        _x=col*6;
        _y=row*8;
}

void graph_c(int c)
{/* Ausgabe eines Zeichens im Grafikmodus                */
/* \n wird erkannt und ausgefhrt                        */
/* alle Zeichen zwischen Space und _ werden ausgegeben   */
/* Kleinbuchstaben werden als Grossbuchstaben ausgegeben */
/* Alle anderen Zeichen werden ignoriert                 */

        int     mask=0x01,
                q,
                i,
                j;

        if ((c=='\n') || (_x>239) )
        { /* neue Zeile */
                _x=0;
                _y+=8;
        }
        if ( (c<' ') || (c>127) ) return;       /* ignorieren! */
        if (c>'`') c=c-'a'+'A';                 /* Kleinbuchstaben */

        _x+=6;                                  /* 6 Pixel weiter */
        for(i=0;i<5;i++)
        {/* Von rechts nach links... */
                for(j=0;j<7;j++)
                {/* Von oben nach unten */
                        q=_chars[c-' '][j] & mask; /* Pixel fr Pixel */
                        if (q) pixel(_x-i,_y+j,WHITE); /* setzen */
                        else   pixel(_x-i,_y+j,BLACK); /* loeschen */
                }
                mask*=2;
        }
}

void printg(char *string)
{/* Ausgabe eines Strings im Grafikmodus */
        int     i;

        for(i=0;string[i];i++)
        {
                graph_c(string[i]);
        }
}

/* hier enden die Text-/Grafik-Routinen                              */
/*-------------------------------------------------------------------*/


/*-------------------------------------------------------------------*/
/* Funktionen zur Grafikansteuerung ueber BIOS                       */

void set_video(mode)
int     mode;
{/* Videomodus setzen    */
/* Bios 0x10, Funktion 0 */

        union REGS inregs,outregs;

        inregs.h.ah=0;                  /* Videomodus setzen */
        inregs.h.al=mode;               /* Modus */
        int86(0x10,&inregs,&outregs);   /* Bios 0x10 */
}

void pixel(int x,int y,int color)
{/* Einen Pixel setzen       */
/*  Bios 0x10, Funktion 0x0c */

        union REGS inregs,outregs;

        inregs.h.ah=0x0c;               /* Pixel setzen */
        inregs.h.al=color;              /* Farbe        */
        inregs.x.cx=x;                  /* Spalte       */
        inregs.x.dx=y;                  /* Zeile        */
        int86(0x10,&inregs,&outregs);   /* Bios 0x10    */
}

/*-------------------------------------------------------------------*/
/* Funktionen zur Ansteuerung der Messkarte                          */

void init_card(void)
{/* Messkarte initialisieren */
        outportb(CTRL,137);
        outportb(PORTA,0);
        outportb(PORTB,0);
}

int messen(int i)
{/* Einen Messwert zurueckgeben                 */
/* Der Messwert muss zwischen 0 und 4095 liegen */
        int     x;

        /* return(rand() % 4096 ); /* Ersatz fuer die UniCard... */

        outport(ADC,i | 8);               /* Kanal i messen      */
        while ( (inportb(ADC) & 64)==0 ); /* Auf Messwert warten */
        x=256*(inportb(ADC+1) & 15)+inportb(ADC+2);
        return(x);
}

/*-------------------------------------------------------------------*/
/* Funktionen zur Ausgabe der Messwerte                              */

void bar(int mess,int mess_alt,int channel)
{/* Bargraph anzeigen */

        int     i,
                m,
                m_a,
                y;

        y=channel*16+12;
        m  =(int)(mess/    20.48+.5);
        m_a=(int)(mess_alt/20.48+.5);

        for(i=m;i<m_a;i++)
        {/* Bargraph ist kuerzer geworden */
                pixel(i+20,y,0);
                if (i%5==0)  pixel(i+20,y-1,BLACK); /* 0.25 Volt */
                if (i%20==0) pixel(i+20,y-2,BLACK); /* 1 Volt    */
        }
        for(i=m_a;i<m;i++)
        {/* Bargraph ist laenger geworden */
                pixel(i+20,y,15);
                if (i%5==0)  pixel(i+20,y-1,WHITE); /* 0.25 Volt */
                if (i%20==0) pixel(i+20,y-2,WHITE); /* 1 Volt    */
        }
}

void val(int mess,int channel)
{/* Messwerte in Volt ausgeben */

        char    string[25];

        sprintf(string,"%d: %8.3f V",channel,mess/409.6);

        go_rc(channel*2,0);
        printg(string);
}

/*-------------------------------------------------------------------*/
/* Hauptprogramm                                                     */

void main(void)
{
        int     i,
                j,
                c;
        int     mess[4],
                mess_alt[4]={0,0,0,0};

        set_video(GRAFICS);
        init_card();
        do
        {/* solange, bis jemand eine Taste drueckt */
                for (i=0;i<4;i++)
                {/* alle 4 Kanaele */
                        mess[i]=messen(i);
                        bar(mess[i],mess_alt[i],i);
                        val(mess[i],i);
                        mess_alt[i]=mess[i];
                }
        }
        while ( kbhit()==0);
        set_video(TEXT);
}
